/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.ModelerPopupPage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.NewBpmnProcess;
import org.apache.syncope.client.console.rest.BpmnProcessRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ImageModalPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.io.IOUtils;

public class BpmnProcessDirectoryPanel
extends DirectoryPanel<BpmnProcess, BpmnProcess, BpmProcessDataProvider, BpmnProcessRestClient> {
    private static final long serialVersionUID = 2705668831139984998L;
    private static final String PREF_WORKFLOW_PAGINATOR_ROWS = "workflow.paginator.rows";
    private static final String FLOWABLE_MODELER_CTX = "flowable-modeler";
    private final BaseModal<String> utility;

    protected BpmnProcessDirectoryPanel(String id, Builder builder) {
        super(id, (DirectoryPanel.Builder)builder);
        this.addNewItemPanelBuilder((ModalPanelBuilder)new AjaxWizardBuilder<BpmnProcess>(new BpmnProcess(), this.pageRef){
            private static final long serialVersionUID = 1633859795677053912L;

            protected WizardModel buildModelSteps(BpmnProcess modelObject, WizardModel wizardModel) {
                return wizardModel;
            }

            protected long getMaxWaitTimeInSeconds() {
                return SyncopeWebApplication.get().getMaxWaitTimeInSeconds();
            }

            protected void sendError(Exception exception) {
                SyncopeConsoleSession.get().onException(exception);
            }

            protected void sendWarning(String message) {
                SyncopeConsoleSession.get().warn((Serializable)((Object)message));
            }

            protected Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> future) {
                return SyncopeConsoleSession.get().execute(future);
            }
        }, false);
        final NewBpmnProcess newBpmnProcess = new NewBpmnProcess("newBpmnProcess", this.container, this.pageRef);
        this.addInnerObject(new Component[]{newBpmnProcess});
        AjaxLink<Void> newBpmnProcessLink = new AjaxLink<Void>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                newBpmnProcess.toggle(target, true);
            }
        };
        ((WebMarkupContainer)this.get("container:content")).addOrReplace(new Component[]{newBpmnProcessLink});
        this.setShowResultPanel(true);
        this.modal.size(Modal.Size.Large);
        this.utility = new BaseModal("outer");
        this.addOuterObject(new Component[]{this.utility});
        this.utility.size(Modal.Size.Large);
        AjaxSubmitLink xmlEditorSubmit = this.utility.addSubmitButton();
        MetaDataRoleAuthorizationStrategy.authorize((Component)xmlEditorSubmit, (Action)RENDER, (String)"BPMN_PROCESS_SET");
        this.utility.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.utility.show(false);
            this.utility.close((IPartialPageRequestHandler)target);
        });
        this.initResultTable();
    }

    protected BpmProcessDataProvider dataProvider() {
        return new BpmProcessDataProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_WORKFLOW_PAGINATOR_ROWS;
    }

    protected List<IColumn<BpmnProcess, String>> getColumns() {
        ArrayList<IColumn<BpmnProcess, String>> columns = new ArrayList<IColumn<BpmnProcess, String>>();
        columns.add((IColumn<BpmnProcess, String>)new PropertyColumn((IModel)new ResourceModel("key"), "key"));
        columns.add((IColumn<BpmnProcess, String>)new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
        return columns;
    }

    public ActionsPanel<BpmnProcess> getActions(final IModel<BpmnProcess> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<BpmnProcess>(){
            private static final long serialVersionUID = -184018732772021627L;

            public void onClick(AjaxRequestTarget target, BpmnProcess ignore) {
                Model wfDefinition = new Model();
                try {
                    wfDefinition.setObject((Object)IOUtils.toString((InputStream)BpmnProcessRestClient.getDefinition(MediaType.APPLICATION_XML_TYPE, ((BpmnProcess)model.getObject()).getKey())));
                }
                catch (IOException e) {
                    DirectoryPanel.LOG.error("Could not get workflow definition", (Throwable)e);
                }
                BpmnProcessDirectoryPanel.this.utility.header((IModel)Model.of((Serializable)((Object)((BpmnProcess)model.getObject()).getKey())));
                BpmnProcessDirectoryPanel.this.utility.setContent((ModalPanel)new XMLEditorPanel(BpmnProcessDirectoryPanel.this.utility, (IModel)wfDefinition, false, BpmnProcessDirectoryPanel.this.pageRef, (IModel)wfDefinition){
                    private static final long serialVersionUID = -7688359318035249200L;
                    final /* synthetic */ IModel val$wfDefinition;
                    {
                        this.val$wfDefinition = iModel;
                        super(modal, content, readOnly, pageRef);
                    }

                    public void onSubmit(AjaxRequestTarget target) {
                        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.val$wfDefinition.getObject()))) {
                            try {
                                BpmnProcessRestClient.setDefinition(MediaType.APPLICATION_XML_TYPE, ((BpmnProcess)model.getObject()).getKey(), (String)this.val$wfDefinition.getObject());
                                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                                target.add(new Component[]{BpmnProcessDirectoryPanel.this.container});
                                BpmnProcessDirectoryPanel.this.utility.show(false);
                                BpmnProcessDirectoryPanel.this.utility.close((IPartialPageRequestHandler)target);
                            }
                            catch (SyncopeClientException e) {
                                SyncopeConsoleSession.get().onException((Exception)((Object)e));
                            }
                            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        }
                    }
                });
                BpmnProcessDirectoryPanel.this.utility.show((IPartialPageRequestHandler)target);
                target.add(new Component[]{BpmnProcessDirectoryPanel.this.utility});
            }
        }, ActionLink.ActionType.EDIT, "BPMN_PROCESS_SET");
        panel.add((ActionLink)new ActionLink<BpmnProcess>(){
            private static final long serialVersionUID = 3109256773218160485L;

            public void onClick(AjaxRequestTarget target, BpmnProcess ignore) {
                BpmnProcessDirectoryPanel.this.modal.header((IModel)Model.of((Serializable)((Object)((BpmnProcess)model.getObject()).getKey())));
                BpmnProcessDirectoryPanel.this.modal.setContent((ModalPanel)new ImageModalPanel(BpmnProcessDirectoryPanel.this.modal, BpmnProcessRestClient.getDiagram(((BpmnProcess)model.getObject()).getKey()), BpmnProcessDirectoryPanel.this.pageRef));
                BpmnProcessDirectoryPanel.this.modal.show((IPartialPageRequestHandler)target);
                target.add(new Component[]{BpmnProcessDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.VIEW, "BPMN_PROCESS_GET");
        panel.add((ActionLink)new ActionLink<BpmnProcess>(){
            private static final long serialVersionUID = -184018732772021627L;

            public Class<? extends Page> getPageClass() {
                return ModelerPopupPage.class;
            }

            public PageParameters getPageParameters() {
                PageParameters parameters = new PageParameters();
                parameters.add("modelerContext", (Object)BpmnProcessDirectoryPanel.FLOWABLE_MODELER_CTX);
                parameters.add("modelId", (Object)((BpmnProcess)model.getObject()).getModelId());
                return parameters;
            }

            public void onClick(AjaxRequestTarget target, BpmnProcess ignore) {
            }
        }, ActionLink.ActionType.EXTERNAL_EDITOR, "BPMN_PROCESS_SET");
        panel.add((ActionLink)new ActionLink<BpmnProcess>(){
            private static final long serialVersionUID = -7978723352517770644L;

            protected boolean statusCondition(BpmnProcess modelObject) {
                return !modelObject.isUserWorkflow();
            }

            public void onClick(AjaxRequestTarget target, BpmnProcess ignore) {
                try {
                    BpmnProcessRestClient.deleteDefinition(((BpmnProcess)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)BpmnProcessDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{BpmnProcessDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting BPMN definition {}", (Object)((BpmnProcess)model.getObject()).getName(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)BpmnProcessDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "BPMN_PROCESS_DELETE", true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected static class BpmProcessDataProvider
    extends DirectoryDataProvider<BpmnProcess> {
        private static final long serialVersionUID = 1764153405387687592L;
        private final SortableDataProviderComparator<BpmnProcess> comparator = new SortableDataProviderComparator((SortableDataProvider)this);

        public BpmProcessDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
        }

        public Iterator<BpmnProcess> iterator(long first, long count) {
            List<BpmnProcess> result = BpmnProcessRestClient.getDefinitions();
            result.sort((Comparator<BpmnProcess>)this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return BpmnProcessRestClient.getDefinitions().size();
        }

        public IModel<BpmnProcess> model(BpmnProcess object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<BpmnProcess, BpmnProcess, BpmnProcessRestClient> {
        private static final long serialVersionUID = 5088962796986706805L;

        public Builder(PageReference pageRef) {
            super((RestClient)new BpmnProcessRestClient(), pageRef);
        }

        protected WizardMgtPanel<BpmnProcess> newInstance(String id, boolean wizardInModal) {
            return new BpmnProcessDirectoryPanel(id, this);
        }
    }
}

