/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.services.BaseMappedAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ReturnRestfulAttributeReleasePolicy
extends BaseMappedAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnRestfulAttributeReleasePolicy.class);
    private static final long serialVersionUID = -6249488544306639050L;
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).build().toObjectMapper();
    private String method = "GET";
    private String endpoint;
    private Map<String, String> headers = new TreeMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        HttpResponse response = null;
        try {
            try (StringWriter writer = new StringWriter();){
                MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, attributes);
                this.headers.put("Content-Type", "application/json");
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.valueOf((String)this.method)).url(SpringExpressionLanguageValueResolver.getInstance().resolve(this.endpoint)).parameters(CollectionUtils.wrap((String)"principal", (Object)context.getPrincipal().getId(), (String)"service", (Object)context.getRegisteredService().getServiceId())).entity(writer.toString()).headers(this.headers).build();
                response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                if (response != null && HttpStatus.resolve((int)response.getStatusLine().getStatusCode()).is2xxSuccessful()) {
                    String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    LOGGER.debug("Policy response received: [{}]", (Object)result);
                    Map returnedAttributes = (Map)MAPPER.readValue(result, (TypeReference)new TypeReference<Map<String, List<Object>>>(){});
                    Map map = (Map)FunctionUtils.doIf((boolean)this.getAllowedAttributes().isEmpty(), () -> returnedAttributes, () -> this.authorizeMappedAttributes(context, returnedAttributes)).get();
                    HttpUtils.close((HttpResponse)response);
                    return map;
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return new HashMap<String, List<Object>>(0);
    }

    @Override
    @Generated
    public String toString() {
        return "ReturnRestfulAttributeReleasePolicy(super=" + super.toString() + ", method=" + this.method + ", endpoint=" + this.endpoint + ", headers=" + this.headers + ")";
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public ReturnRestfulAttributeReleasePolicy setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public ReturnRestfulAttributeReleasePolicy setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Generated
    public ReturnRestfulAttributeReleasePolicy setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @Generated
    public ReturnRestfulAttributeReleasePolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnRestfulAttributeReleasePolicy)) {
            return false;
        }
        ReturnRestfulAttributeReleasePolicy other = (ReturnRestfulAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$method = this.method;
        String other$method = other.method;
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$endpoint = this.endpoint;
        String other$endpoint = other.endpoint;
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReturnRestfulAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $method = this.method;
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $endpoint = this.endpoint;
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }
}

