/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;

public final class SyncopeUserTOConverterUtils {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public static Map<String, List<Object>> convert(JsonNode user) {
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        if (user.has("securityQuestion") && !user.get("securityQuestion").isNull()) {
            attributes.put("syncopeUserSecurityQuestion", CollectionUtils.wrapList((Object[])new Object[]{user.get("securityQuestion").asText()}));
        }
        attributes.put("syncopeUserStatus", CollectionUtils.wrapList((Object[])new Object[]{user.get("status").asText()}));
        attributes.put("syncopeUserRealm", CollectionUtils.wrapList((Object[])new Object[]{user.get("realm").asText()}));
        attributes.put("syncopeUserCreator", CollectionUtils.wrapList((Object[])new Object[]{user.get("creator").asText()}));
        attributes.put("syncopeUserCreationDate", CollectionUtils.wrapList((Object[])new Object[]{user.get("creationDate").asText()}));
        if (user.has("changePwdDate") && !user.get("changePwdDate").isNull()) {
            attributes.put("syncopeUserChangePwdDate", CollectionUtils.wrapList((Object[])new Object[]{user.get("changePwdDate").asText()}));
        }
        if (user.has("lastLoginDate") && !user.get("lastLoginDate").isNull()) {
            attributes.put("syncopeUserLastLoginDate", CollectionUtils.wrapList((Object[])new Object[]{user.get("lastLoginDate").asText()}));
        }
        SyncopeUserTOConverterUtils.collectListableAttribute(attributes, user, "roles", "syncopeUserRoles");
        SyncopeUserTOConverterUtils.collectListableAttribute(attributes, user, "dynRoles", "syncopeUserDynRoles");
        SyncopeUserTOConverterUtils.collectListableAttribute(attributes, user, "dynRealms", "syncopeUserDynRealms");
        if (user.has("memberships")) {
            ArrayList memberships = new ArrayList();
            user.get("memberships").forEach(m -> memberships.add(m.get("groupName").asText()));
            if (!memberships.isEmpty()) {
                attributes.put("syncopeUserMemberships", memberships);
            }
        }
        if (user.has("dynMemberships")) {
            ArrayList dynMemberships = new ArrayList();
            user.get("dynMemberships").forEach(m -> dynMemberships.add(m.get("groupName").asText()));
            if (!dynMemberships.isEmpty()) {
                attributes.put("syncopeUserDynMemberships", dynMemberships);
            }
        }
        if (user.has("relationships")) {
            ArrayList relationships = new ArrayList();
            user.get("relationships").forEach(r -> relationships.add(r.get("type").asText() + ";" + r.get("otherEndName").asText()));
            if (!relationships.isEmpty()) {
                attributes.put("syncopeUserRelationships", relationships);
            }
        }
        if (user.has("plainAttrs")) {
            user.get("plainAttrs").forEach(a -> attributes.put("syncopeUserAttr_" + a.get("schema").asText(), (List)MAPPER.convertValue((Object)a.get("values"), ArrayList.class)));
        }
        if (user.has("derAttrs")) {
            user.get("derAttrs").forEach(a -> attributes.put("syncopeUserAttr_" + a.get("schema").asText(), (List)MAPPER.convertValue((Object)a.get("values"), ArrayList.class)));
        }
        if (user.has("virAttrs")) {
            user.get("virAttrs").forEach(a -> attributes.put("syncopeUserAttr_" + a.get("schema").asText(), (List)MAPPER.convertValue((Object)a.get("values"), ArrayList.class)));
        }
        return attributes;
    }

    private static void collectListableAttribute(Map<String, List<Object>> attributes, JsonNode user, String syncopeAttribute, String casAttribute) {
        List values;
        List list = values = user.has(syncopeAttribute) ? (List)MAPPER.convertValue((Object)user.get(syncopeAttribute), ArrayList.class) : CollectionUtils.wrapList((Object[])new Object[0]);
        if (!values.isEmpty()) {
            attributes.put(casAttribute, values);
        }
    }

    @Generated
    private SyncopeUserTOConverterUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

