/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.CasProtocolValidationSpecification;

public class CasProtocolVersionValidationSpecification
implements CasProtocolValidationSpecification {
    private final Set<String> supportedVersions;

    public CasProtocolVersionValidationSpecification(Set<CasProtocolValidationSpecification.CasProtocolVersions> supportedVersions) {
        this.supportedVersions = supportedVersions.stream().map(Enum::name).collect(Collectors.toSet());
    }

    public boolean isSatisfiedBy(Assertion assertion, HttpServletRequest request) {
        RegisteredService registeredService = assertion.getRegisteredService();
        if (registeredService instanceof CasModelRegisteredService) {
            CasModelRegisteredService casService = (CasModelRegisteredService)registeredService;
            return casService.getSupportedProtocols().isEmpty() || casService.getSupportedProtocols().containsAll(this.supportedVersions);
        }
        return false;
    }
}

