/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.utilities;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.syncope.installer.utilities.InstallLog;

public class HttpUtils {
    private static final String HTTPS_URL_TEMPLATE = "https://%s:%s";
    private static final String HTTP_URL_TEMPLATE = "http://%s:%s";
    private final CloseableHttpClient httpClient;
    private final boolean isSsl;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final HttpHost targetHost;
    private final AbstractUIProcessHandler handler;

    public HttpUtils(boolean isSsl, String host, String port, String username, String password, AbstractUIProcessHandler handler) {
        this.isSsl = isSsl;
        this.host = host;
        this.port = Integer.parseInt(port);
        if (isSsl) {
            this.httpClient = HttpUtils.createHttpsClient();
            this.targetHost = new HttpHost(this.host, this.port, "https");
        } else {
            this.httpClient = HttpClients.createDefault();
            this.targetHost = new HttpHost(this.host, this.port, "http");
        }
        this.username = username;
        this.password = password;
        this.handler = handler;
    }

    public int getWithBasicAuth(String path) {
        HttpGet httpGet = this.isSsl ? new HttpGet(String.format(HTTPS_URL_TEMPLATE, this.host, this.port) + path) : new HttpGet(String.format(HTTP_URL_TEMPLATE, this.host, this.port) + path);
        int status = 0;
        this.handler.logOutput("Calling " + httpGet.getURI(), true);
        InstallLog.getInstance().info("Calling " + httpGet.getURI());
        try (CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)httpGet, (HttpContext)this.setAuth(this.targetHost, new BasicScheme()));){
            status = response.getStatusLine().getStatusCode();
            this.handler.logOutput("Calling status " + status, true);
            InstallLog.getInstance().info("Calling status " + status);
        }
        catch (IOException e) {
            String messageError = "Error in " + path + ": " + e.getMessage();
            this.handler.emitError(messageError, messageError);
            InstallLog.getInstance().error(messageError);
        }
        return status;
    }

    public String postWithDigestAuth(String url, String file) {
        String responseBodyAsString = "";
        try (CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)this.httpPost(url, MultipartEntityBuilder.create().addPart("bin", new FileBody(new File(file))).build()), (HttpContext)this.setAuth(this.targetHost, new DigestScheme()));){
            responseBodyAsString = IOUtils.toString(response.getEntity().getContent(), Charset.forName("UTF-8"));
            this.handler.logOutput("Http status: " + response.getStatusLine().getStatusCode(), true);
            InstallLog.getInstance().info("Http status: " + response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            String messageError = "Error calling " + url + ": " + e.getMessage();
            this.handler.emitError(messageError, messageError);
            InstallLog.getInstance().error(messageError);
        }
        return responseBodyAsString;
    }

    public int postWithStringEntity(String url, String stringEntity) {
        int status = 0;
        try {
            HttpPost httPost = this.httpPost(url, new StringEntity(stringEntity));
            httPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            try (CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)httPost, (HttpContext)this.setAuth(this.targetHost, new DigestScheme()));){
                status = response.getStatusLine().getStatusCode();
                this.handler.logOutput("Http status: " + status, true);
                InstallLog.getInstance().info("Http status: " + status);
            }
        }
        catch (IOException ioe) {
            String messageError = "Error calling " + url + ": " + ioe.getMessage();
            this.handler.emitError(messageError, messageError);
            InstallLog.getInstance().error(messageError);
        }
        return status;
    }

    private HttpClientContext setAuth(HttpHost targetHost, AuthScheme authScheme) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), new UsernamePasswordCredentials(this.username, this.password));
        HttpClientContext context = HttpClientContext.create();
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targetHost, authScheme);
        context.setAuthCache(authCache);
        context.setCredentialsProvider(credsProvider);
        return context;
    }

    private HttpPost httpPost(String url, HttpEntity reqEntity) {
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity(reqEntity);
        this.handler.logOutput("Calling " + httppost.getURI(), true);
        InstallLog.getInstance().info("Calling " + httppost.getURI());
        return httppost;
    }

    public static int ping(boolean isSsl, String host, String port) {
        int status = 0;
        try {
            status = isSsl ? HttpUtils.createHttpsClient().execute(new HttpGet(String.format(HTTPS_URL_TEMPLATE, host, port))).getStatusLine().getStatusCode() : HttpClients.createDefault().execute(new HttpGet(String.format(HTTP_URL_TEMPLATE, host, port))).getStatusLine().getStatusCode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    private static CloseableHttpClient createHttpsClient() {
        CloseableHttpClient chc = null;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustSelfSignedStrategy());
            chc = HttpClients.custom().setSSLSocketFactory(new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chc;
    }
}

