/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import org.apache.syncope.installer.enums.DBs;
import org.apache.syncope.installer.processes.BaseProcess;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;

public class PersistenceProcess
extends BaseProcess {
    private String installPath;
    private String artifactId;
    private DBs dbSelected;
    private String persistenceUrl;
    private String persistenceUser;
    private String persistencePassword;
    private boolean mysqlInnoDB;
    private String schema;

    @Override
    public void run(AbstractUIProcessHandler handler, String[] args) {
        this.installPath = args[0];
        this.artifactId = args[1];
        this.dbSelected = DBs.fromDbName(args[2]);
        this.persistenceUrl = args[3];
        this.persistenceUser = args[4];
        this.persistencePassword = args[5];
        this.mysqlInnoDB = Boolean.valueOf(args[6]);
        this.schema = args[7];
        StringBuilder masterProperties = new StringBuilder("# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n");
        this.setSyncopeInstallDir(this.installPath, this.artifactId);
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        File provisioningFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("provisioningPropertiesFile"));
        String provisioningFileString = fileSystemUtils.readFile(provisioningFile);
        StringBuilder provisioningProperties = new StringBuilder(provisioningFileString.substring(0, provisioningFileString.indexOf("quartz.jobstore")));
        handler.logOutput("Configure persistence for " + (Object)((Object)this.dbSelected), false);
        InstallLog.getInstance().info("Configure persistence for " + (Object)((Object)this.dbSelected));
        switch (this.dbSelected) {
            case POSTGRES: {
                provisioningProperties.append("quartz.jobstore=org.quartz.impl.jdbcjobstore.PostgreSQLDelegate\nquartz.sql=tables_postgres.sql\n");
                masterProperties.append(String.format("Master.driverClassName=org.postgresql.Driver%nMaster.url=%s%nMaster.schema=%nMaster.username=%s%nMaster.password=%s%nMaster.databasePlatform=org.apache.openjpa.jdbc.sql.PostgresDictionary%nMaster.orm=META-INF/spring-orm.xml%nMaster.pool.validationQuery=SELECT 1%nMaster.pool.maxActive=10%nMaster.pool.minIdle=2%nMaster.audit.sql=audit.sql%n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                break;
            }
            case MYSQL: {
                provisioningProperties.append("quartz.jobstore=org.quartz.impl.jdbcjobstore.StdJDBCDelegate\n");
                provisioningProperties.append(this.mysqlInnoDB ? "quartz.sql=tables_mysql_innodb.sql" : "quartz.sql=tables_mysql.sql");
                masterProperties.append(String.format("Master.driverClassName=com.mysql.jdbc.Driver%nMaster.url=%s&relaxAutoCommit=true%nMaster.schema=%nMaster.username=%s%nMaster.password=%s%nMaster.databasePlatform=org.apache.openjpa.jdbc.sql.MySQLDictionary(blobTypeName=LONGBLOB)%nMaster.orm=META-INF/spring-orm.xml%nMaster.pool.validationQuery=SELECT 1%nMaster.pool.maxActive=10%nMaster.pool.minIdle=2%nMaster.audit.sql=audit.sql%n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                break;
            }
            case MARIADB: {
                provisioningProperties.append("quartz.jobstore=org.quartz.impl.jdbcjobstore.StdJDBCDelegate\nquartz.sql=tables_mariadb.sql\n");
                masterProperties.append(String.format("Master.driverClassName=org.mariadb.jdbc.Driver%nMaster.url=%s%nMaster.schema=%nMaster.username=%s%nMaster.password=%s%nMaster.databasePlatform=org.apache.openjpa.jdbc.sql.MariaDBDictionary(blobTypeName=LONGBLOB)%nMaster.orm=META-INF/spring-orm.xml%nMaster.pool.validationQuery=SELECT 1%nMaster.pool.maxActive=10%nMaster.pool.minIdle=2%nMaster.audit.sql=audit.sql%n", this.persistenceUrl, this.persistenceUser, this.persistencePassword));
                break;
            }
            case ORACLE: {
                provisioningProperties.append("quartz.jobstore=org.quartz.impl.jdbcjobstore.oracle.OracleDelegate\nquartz.sql=tables_oracle.sql\n");
                masterProperties.append(String.format("Master.driverClassName=oracle.jdbc.OracleDriver%nMaster.url=%s%nMaster.schema=%s%nMaster.username=%s%nMaster.password=%s%nMaster.databasePlatform=org.apache.openjpa.jdbc.sql.OracleDictionary%nMaster.orm=META-INF/spring-orm-oracle.xml%nMaster.pool.validationQuery=SELECT 1 FROM DUAL%nMaster.pool.maxActive=10%nMaster.pool.minIdle=2%nMaster.audit.sql=audit_oracle.sql%n", this.persistenceUrl, this.schema, this.persistenceUser, this.persistencePassword));
                break;
            }
            case SQLSERVER: {
                provisioningProperties.append("quartz.jobstore=org.quartz.impl.jdbcjobstore.MSSQLDelegate\nquartz.sql=tables_sqlServer.sql\n");
                masterProperties.append(String.format("Master.driverClassName=com.microsoft.sqlserver.jdbc.SQLServerDriver%nMaster.url=%s%nMaster.schema=%s%nMaster.username=%s%nMaster.password=%s%nMaster.databasePlatform=org.apache.openjpa.jdbc.sql.SQLServerDictionary%nMaster.orm=META-INF/spring-orm-sqlserver.xml%nMaster.pool.validationQuery=SELECT 1%nMaster.pool.maxActive=10%nMaster.pool.minIdle=2%nMaster.audit.sql=audit_sqlserver.sql%n", this.persistenceUrl, this.schema, this.persistenceUser, this.persistencePassword));
                break;
            }
        }
        fileSystemUtils.writeToFile(new File(this.syncopeInstallDir + PROPERTIES.getProperty("provisioningPropertiesFile")), provisioningProperties.toString());
        fileSystemUtils.writeToFile(new File(this.syncopeInstallDir + PROPERTIES.getProperty("masterPropertiesFile")), masterProperties.toString());
    }
}

