/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.TwoColumnLayout;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.userinput.DelegatingPrompt;
import com.izforge.izpack.panels.userinput.LoggingPrompt;
import com.izforge.izpack.panels.userinput.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.userinput.field.ElementReader;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldHelper;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.gui.Component;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import com.izforge.izpack.panels.userinput.gui.GUIFieldFactory;
import com.izforge.izpack.panels.userinput.gui.UpdateListener;
import com.izforge.izpack.panels.userinput.gui.custom.GUICustomField;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class UserInputPanel
extends IzPanel {
    private static final long serialVersionUID = 8667949467748997226L;
    private static final String SUMMARY_KEY = "summaryKey";
    private static final String TOPBUFFER = "topBuffer";
    private static final String RIGID = "rigid";
    private static final String DISPLAY_HIDDEN = "displayHidden";
    private static final String DISPLAY_HIDDEN_CONDITION = "displayHiddenCondition";
    private static final String READONLY = "readonly";
    private static final String READONLY_CONDITION = "readonlyCondition";
    private final IXMLElement spec;
    private boolean eventsActivated = false;
    private boolean saving = false;
    private final List<GUIField> views = new ArrayList<GUIField>();
    private JPanel panel;
    private JComponent firstFocusedComponent;
    private final RulesEngine rules;
    private final ObjectFactory factory;
    private final PlatformModelMatcher matcher;
    private final Prompt prompt;
    private final DelegatingPrompt delegatingPrompt;
    private UserInputPanelSpec userInputModel;

    public UserInputPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, RulesEngine rules, ObjectFactory factory, PlatformModelMatcher matcher, Prompt prompt) {
        super(panel, parent, installData, resources);
        boolean readonly;
        ElementReader reader;
        Condition globalConstraint;
        boolean isDisplayingHidden;
        this.rules = rules;
        this.factory = factory;
        this.matcher = matcher;
        this.prompt = prompt;
        this.delegatingPrompt = new DelegatingPrompt(prompt);
        this.spec = this.readSpec();
        try {
            isDisplayingHidden = Boolean.parseBoolean(this.spec.getAttribute(DISPLAY_HIDDEN));
        }
        catch (Exception ignore) {
            isDisplayingHidden = false;
        }
        panel.setDisplayHidden(isDisplayingHidden);
        String condition = this.spec.getAttribute(DISPLAY_HIDDEN_CONDITION);
        if (condition != null && !condition.isEmpty()) {
            panel.setDisplayHiddenCondition(condition);
        }
        if ((globalConstraint = (reader = new ElementReader(this.userInputModel.getConfig())).getComplexPanelCondition(this.spec, matcher, installData, rules)) != null) {
            rules.addPanelCondition(panel, globalConstraint);
        }
        try {
            readonly = Boolean.parseBoolean(this.spec.getAttribute(READONLY));
        }
        catch (Exception ignore) {
            readonly = false;
        }
        panel.setReadonly(readonly);
        condition = this.spec.getAttribute(READONLY_CONDITION);
        if (condition != null && !condition.isEmpty()) {
            panel.setReadonlyCondition(condition);
        }
        this.init();
        this.addScrollPane();
        Dimension size = this.getMaximumSize();
        this.setSize(size.width, size.height);
        this.buildUI();
        this.updateUIElements();
        this.validate();
    }

    @Override
    public boolean isValidated() {
        return this.readInput(this.prompt);
    }

    @Override
    public void saveData() {
        this.saving = true;
        this.readInput(this.prompt, true);
    }

    @Override
    public void panelActivate() {
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parent.skipPanel();
        } else {
            this.eventsActivated = false;
            this.buildUI();
            this.updateUIElements();
            this.eventsActivated = true;
        }
        this.updateDialog();
        if (this.firstFocusedComponent != null) {
            this.setInitialFocus(this.firstFocusedComponent);
            this.firstFocusedComponent.requestFocusInWindow();
        }
    }

    @Override
    public void createInstallationRecord(IXMLElement rootElement) {
        new UserInputPanelAutomationHelper(this.views).createInstallationRecord(this.installData, rootElement);
    }

    private void init() {
        this.eventsActivated = false;
        super.removeAll();
        this.views.clear();
        this.setLayout(new BorderLayout());
        this.panel = new JPanel();
        if (this.spec == null) {
            return;
        }
        ButtonFactory.clearPanelButtonMnemonics();
        GUIFieldFactory viewFactory = new GUIFieldFactory(this.installData, this, this.parent, this.delegatingPrompt);
        UpdateListener listener = new UpdateListener(){

            @Override
            public void updated() {
                UserInputPanel.this.updateDialog();
            }
        };
        List<Field> fields = this.userInputModel.createFields(this.spec);
        for (Field field : fields) {
            GUIField view = viewFactory.create(field, this.userInputModel, this.spec);
            view.setUpdateListener(listener);
            this.views.add(view);
        }
        this.eventsActivated = true;
    }

    private void updateUIElements() {
        boolean updated = false;
        this.firstFocusedComponent = null;
        for (GUIField view : this.views) {
            Field field = view.getField();
            if (field.isConditionTrue()) {
                view.setDisplayed(true);
                if (this.firstFocusedComponent == null) {
                    this.firstFocusedComponent = view.getFirstFocusableComponent();
                }
            } else {
                view.setDisplayed(false);
            }
            updated |= view.updateView();
        }
        if (updated) {
            super.invalidate();
        }
    }

    private void buildUI() {
        HashSet<String> affectedVariables = new HashSet<String>();
        this.panel.removeAll();
        this.panel.setLayout(this.createPanelLayout());
        for (GUIField view : this.views) {
            boolean addToPanel;
            boolean enabled;
            Field fieldDefinition = view.getField();
            Panel metadata = this.getMetadata();
            boolean required = FieldHelper.isRequired(fieldDefinition, this.installData, this.matcher);
            if (required && fieldDefinition.isConditionTrue()) {
                enabled = !fieldDefinition.isEffectiveReadonly(metadata.isReadonly() || metadata.getReadonlyCondition() != null && this.rules.isConditionTrue(metadata.getReadonlyCondition()), this.rules);
                addToPanel = true;
                view.setDisplayed(true);
            } else if (required && fieldDefinition.isEffectiveDisplayHidden(metadata.isDisplayHidden() || metadata.getDisplayHiddenCondition() != null && this.rules.isConditionTrue(metadata.getDisplayHiddenCondition()), this.rules)) {
                enabled = false;
                addToPanel = true;
                view.setDisplayed(true);
            } else {
                enabled = false;
                addToPanel = false;
                view.setDisplayed(false);
            }
            if (!addToPanel) continue;
            for (Component component : view.getComponents()) {
                component.setEnabled(enabled);
                this.panel.add((java.awt.Component)component.getComponent(), component.getConstraints());
            }
            String var = view.getVariable();
            if (var == null) continue;
            affectedVariables.add(var);
        }
        this.getMetadata().setAffectedVariableNames(affectedVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readInput(Prompt prompt, boolean skipValidation) {
        this.delegatingPrompt.setPrompt(prompt);
        try {
            for (GUIField view : this.views) {
                Field field = view.getField();
                if (!view.isDisplayed() || !field.isConditionTrue()) continue;
                if (this.saving) {
                    field.setSaving(true);
                }
                if (skipValidation) {
                    view.updateField(prompt, true);
                    continue;
                }
                if (view.updateField(prompt)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.saving = false;
        }
        return true;
    }

    private boolean readInput(Prompt prompt) {
        return this.readInput(prompt, false);
    }

    private IXMLElement readSpec() {
        this.userInputModel = new UserInputPanelSpec(this.getResources(), this.installData, this.factory, this.matcher);
        return this.userInputModel.getPanelSpec(this.getMetadata());
    }

    private void updateDialog() {
        if (this.eventsActivated) {
            this.eventsActivated = false;
            this.readInput(LoggingPrompt.INSTANCE, true);
            this.updateUIElements();
            this.buildUI();
            this.revalidate();
            this.repaint();
            Panel metadata = this.getMetadata();
            if (metadata.isVisited()) {
                Set<String> blockedNames = metadata.getAffectedVariableNames();
                Set<String> originalBlockedNames = this.installData.getVariables().getBlockedVariableNames(metadata);
                HashSet<String> addedBlockedNames = new HashSet<String>();
                HashSet<String> removedBlockedNames = new HashSet<String>();
                if (blockedNames != null) {
                    for (String blockedName : blockedNames) {
                        if (this.installData.getVariables().isBlockedVariableName(blockedName)) continue;
                        addedBlockedNames.add(blockedName);
                    }
                }
                if (originalBlockedNames != null) {
                    for (String blockedName : originalBlockedNames) {
                        if (blockedNames.contains(blockedName)) continue;
                        removedBlockedNames.add(blockedName);
                    }
                }
                if (!addedBlockedNames.isEmpty()) {
                    this.installData.getVariables().registerBlockedVariableNames(addedBlockedNames, metadata);
                }
                if (!removedBlockedNames.isEmpty()) {
                    this.installData.getVariables().unregisterBlockedVariableNames(removedBlockedNames, metadata);
                }
            }
            this.eventsActivated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TwoColumnLayout createPanelLayout() {
        TwoColumnLayout layout;
        int topbuff = 25;
        boolean rigid = false;
        try {
            topbuff = Integer.parseInt(this.spec.getAttribute(TOPBUFFER));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            rigid = Boolean.parseBoolean(this.spec.getAttribute(RIGID));
        }
        catch (Exception ignore) {
        }
        finally {
            layout = new TwoColumnLayout(10, 5, 30, topbuff, rigid, 0);
        }
        return layout;
    }

    private void addScrollPane() {
        JScrollPane scroller = new JScrollPane(this.panel);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        scroller.setBorder(emptyBorder);
        scroller.setViewportBorder(emptyBorder);
        scroller.getVerticalScrollBar().setBorder(emptyBorder);
        scroller.getHorizontalScrollBar().setBorder(emptyBorder);
        this.add((java.awt.Component)scroller, "Center");
    }

    @Override
    public String getSummaryCaption() {
        String associatedLabel;
        try {
            associatedLabel = this.spec.getAttribute(SUMMARY_KEY);
        }
        catch (Exception setToNull) {
            associatedLabel = null;
        }
        return this.installData.getMessages().get(associatedLabel, new Object[0]);
    }

    @Override
    public String getSummaryBody() {
        if (this.getMetadata().hasCondition() && !this.rules.isConditionTrue(this.getMetadata().getCondition())) {
            return null;
        }
        StringBuilder entries = new StringBuilder();
        for (GUIField view : this.views) {
            if (!view.isDisplayed() || view.getVariable() == null) continue;
            if (view instanceof GUICustomField) {
                entries.append(this.getCustomSummary((GUICustomField)view));
                continue;
            }
            entries.append(this.getViewSummary(view));
        }
        return entries.toString();
    }

    private String getViewSummary(GUIField view) {
        String associatedVariable = view.getVariable();
        String associatedLabel = view.getSummaryKey();
        if (associatedLabel != null) {
            String key = this.installData.getMessages().get(associatedLabel, new Object[0]);
            String value = this.installData.getVariable(associatedVariable);
            return key + " " + value + "<br>";
        }
        return "";
    }

    private String getCustomSummary(GUICustomField customField) {
        List<String> labels = customField.getLabels();
        List<String> variables = customField.getVariables();
        int numberOfColumns = labels.size();
        int column = 0;
        int row = 0;
        StringBuilder entry = new StringBuilder();
        for (String variable : variables) {
            String tab;
            boolean firstColumn;
            boolean bl = firstColumn = column % numberOfColumns == 0;
            if (!firstColumn) {
                tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
                ++column;
            } else {
                tab = "";
                column = 1;
            }
            String key = this.installData.getMessages().get(this.installData.getMessages().get(labels.get(column - 1), new Object[0]), new Object[0]);
            String value = this.installData.getVariable(variable);
            if (key == null) continue;
            if (firstColumn) {
                entry.append(String.format("%1$-3s", ++row + ". "));
            }
            entry.append(tab).append(key);
            entry.append(" ").append(value);
            entry.append("<br>");
        }
        return entry.toString();
    }
}

