/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.util.StringUtil;

public class MySQLDictionary
extends DBDictionary {
    public static final String SELECT_HINT = "openjpa.hint.MySQLSelectHint";
    public static final String DELIMITER_BACK_TICK = "`";
    public String tableType = "innodb";
    public boolean useClobs = true;
    public boolean driverDeserializesBlobs = false;
    public boolean optimizeMultiTableDeletes = false;
    public static final String tinyBlobTypeName = "TINYBLOB";
    public static final String mediumBlobTypeName = "MEDIUMBLOB";
    public static final String longBlobTypeName = "LONGBLOB";
    public static final String tinyTextTypeName = "TINYTEXT";
    public static final String mediumTextTypeName = "MEDIUMTEXT";
    public static final String longTextTypeName = "LONGTEXT";

    public MySQLDictionary() {
        this.platform = "MySQL";
        this.validationSQL = "SELECT NOW()";
        this.distinctCountColumnSeparator = ",";
        this.supportsDeferredConstraints = false;
        this.constraintNameMode = "mid";
        this.supportsMultipleNontransactionalResultSets = false;
        this.requiresAliasForSubselect = true;
        this.requiresTargetForDelete = true;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.datePrecision = 1000;
        this.concatenateFunction = "CONCAT({0},{1})";
        this.maxTableNameLength = 64;
        this.maxColumnNameLength = 64;
        this.maxIndexNameLength = 64;
        this.maxConstraintNameLength = 64;
        this.maxIndexesPerTable = 32;
        this.schemaCase = "preserve";
        this.supportsAutoAssign = true;
        this.lastGeneratedKeyQuery = "SELECT LAST_INSERT_ID()";
        this.autoAssignClause = "AUTO_INCREMENT";
        this.clobTypeName = "TEXT";
        this.longVarcharTypeName = "TEXT";
        this.longVarbinaryTypeName = "LONG VARBINARY";
        this.timestampTypeName = "DATETIME";
        this.xmlTypeName = "TEXT";
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BOOL", "LONG VARBINARY", mediumBlobTypeName, longBlobTypeName, tinyBlobTypeName, "LONG VARCHAR", mediumTextTypeName, longTextTypeName, "TEXT", tinyTextTypeName, "DOUBLE PRECISION", "ENUM", "SET", "DATETIME"));
        this.reservedWordSet.addAll(Arrays.asList("AUTO_INCREMENT", "BINARY", "BLOB", "CHANGE", "ENUM", "INFILE", "INT1", "INT2", "INT4", "FLOAT1", "FLOAT2", "FLOAT4", "LOAD", "MEDIUMINT", "OUTFILE", "REPLACE", "STARTING", "TEXT", "UNSIGNED", "ZEROFILL", "INDEX"));
        this.invalidColumnWordSet.addAll(Arrays.asList("ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "END-EXEC", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GENERATED", "GET", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", longBlobTypeName, longTextTypeName, "LOOP", "LOW_PRIORITY", "MATCH", "MAXVALUE", mediumBlobTypeName, "MEDIUMINT", mediumTextTypeName, "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NO_WRITE_TO_BINLOG", "NOT", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PARTITION", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RANGE", "READ", "READS", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESIGNAL", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SIGNAL", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", tinyBlobTypeName, "TINYINT", tinyTextTypeName, "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL", "INDEX", "SELECT"));
        this.requiresSearchStringEscapeForLike = true;
        this.searchStringEscape = "\\\\";
        this.typeModifierSet.addAll(Arrays.asList("UNSIGNED", "ZEROFILL"));
        this.setLeadingDelimiter(DELIMITER_BACK_TICK);
        this.setTrailingDelimiter(DELIMITER_BACK_TICK);
        this.fixedSizeTypeNameSet.remove("NUMERIC");
        this.dateFractionDigits = 0;
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        int min;
        int maj;
        DatabaseMetaData metaData;
        block8: {
            super.connectedConfiguration(conn);
            metaData = conn.getMetaData();
            maj = 0;
            min = 0;
            if (this.isJDBC3) {
                maj = metaData.getDatabaseMajorVersion();
                min = metaData.getDatabaseMinorVersion();
            } else {
                try {
                    String productVersion = metaData.getDatabaseProductVersion();
                    int[] versions = MySQLDictionary.getMajorMinorVersions(productVersion);
                    maj = versions[0];
                    min = versions[1];
                }
                catch (IllegalArgumentException e) {
                    if (!this.log.isWarnEnabled()) break block8;
                    this.log.warn((Object)e.toString(), (Throwable)e);
                }
            }
        }
        if (maj < 4 || maj == 4 && min < 1) {
            this.supportsSubselect = false;
            this.allowsAliasInBulkClause = false;
            this.supportsForeignKeysComposite = false;
        }
        if (maj > 5 || maj == 5 && min >= 1) {
            this.supportsXMLColumn = true;
        }
        if (maj > 5 || maj == 5 && min >= 7) {
            this.timestampTypeName = "DATETIME{0}";
            this.fixedSizeTypeNameSet.remove(this.timestampTypeName);
            this.fractionalTypeNameSet.add(this.timestampTypeName);
        }
        if (metaData.getDriverMajorVersion() < 5) {
            this.driverDeserializesBlobs = true;
        }
    }

    @Override
    public Connection decorate(Connection conn) throws SQLException {
        conn = super.decorate(conn);
        String driver = this.conf.getConnectionDriverName();
        if ("com.mysql.jdbc.ReplicationDriver".equals(driver)) {
            conn.setReadOnly(true);
        }
        return conn;
    }

    private static int[] getMajorMinorVersions(String versionStr) throws IllegalArgumentException {
        String[] arr;
        int beginIndex = 0;
        versionStr = versionStr.trim();
        char[] charArr = versionStr.toCharArray();
        for (int i = 0; i < charArr.length; ++i) {
            if (!Character.isDigit(charArr[i])) continue;
            beginIndex = i;
            break;
        }
        int endIndex = charArr.length;
        for (int i = beginIndex + 1; i < charArr.length; ++i) {
            if (charArr[i] == '.' || Character.isDigit(charArr[i])) continue;
            endIndex = i;
            break;
        }
        if ((arr = versionStr.substring(beginIndex, endIndex).split("\\.")).length < 2) {
            throw new IllegalArgumentException();
        }
        int maj = Integer.parseInt(arr[0]);
        int min = Integer.parseInt(arr[1]);
        return new int[]{maj, min};
    }

    @Override
    public String[] getCreateTableSQL(Table table) {
        String[] sql = super.getCreateTableSQL(table);
        if (!StringUtil.isEmpty((String)this.tableType)) {
            sql[0] = sql[0] + " ENGINE = " + this.tableType;
        }
        return sql;
    }

    @Override
    public String[] getDropIndexSQL(Index index) {
        return new String[]{"DROP INDEX " + this.getFullName(index) + " ON " + this.getFullName(index.getTable(), false)};
    }

    @Override
    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        if (DBIdentifier.isNull(pk.getIdentifier())) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " DROP PRIMARY KEY"};
    }

    @Override
    public String[] getDropForeignKeySQL(ForeignKey fk, Connection conn) {
        if (DBIdentifier.isNull(fk.getIdentifier())) {
            String[] stringArray;
            DBIdentifier fkName = fk.loadIdentifierFromDB(this, conn);
            if (fkName == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP FOREIGN KEY " + this.toDBName(fkName);
            }
            String[] retVal = stringArray;
            return retVal;
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP FOREIGN KEY " + this.toDBName(fk.getIdentifier())};
    }

    @Override
    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        String[] sql = super.getAddPrimaryKeySQL(pk);
        Column[] cols = pk.getColumns();
        String[] ret = new String[cols.length + sql.length];
        for (int i = 0; i < cols.length; ++i) {
            ret[i] = "ALTER TABLE " + this.getFullName(cols[i].getTable(), false) + " CHANGE " + this.toDBName(cols[i].getIdentifier()) + " " + this.toDBName(cols[i].getIdentifier()) + " " + this.getTypeName(cols[i]) + " NOT NULL";
        }
        System.arraycopy(sql, 0, ret, cols.length, sql.length);
        return ret;
    }

    @Override
    public String[] getDeleteTableContentsSQL(Table[] tables, Connection conn) {
        if (!this.optimizeMultiTableDeletes) {
            return super.getDeleteTableContentsSQL(tables, conn);
        }
        StringBuilder buf = new StringBuilder(tables.length * 8);
        buf.append("DELETE FROM ");
        for (int i = 0; i < tables.length; ++i) {
            buf.append(this.toDBName(tables[i].getFullIdentifier()));
            if (i >= tables.length - 1) continue;
            buf.append(", ");
        }
        return new String[]{buf.toString()};
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        buf.append(" LIMIT ").appendValue(start).append(", ");
        if (end == Long.MAX_VALUE) {
            buf.appendValue(Long.MAX_VALUE);
        } else {
            buf.appendValue(end - start);
        }
    }

    @Override
    protected Column newColumn(ResultSet colMeta) throws SQLException {
        Column col = super.newColumn(colMeta);
        if (col.isNotNull() && "0".equals(col.getDefaultString())) {
            col.setDefaultString(null);
        }
        return col;
    }

    @Override
    public Object getBlobObject(ResultSet rs, int column, JDBCStore store) throws SQLException {
        if (this.useGetBytesForBlobs || this.useGetObjectForBlobs || !this.driverDeserializesBlobs) {
            return super.getBlobObject(rs, column, store);
        }
        return rs.getObject(column);
    }

    @Override
    public int getPreferredType(int type) {
        if (type == 2005 && !this.useClobs) {
            return -1;
        }
        if (type == 2013) {
            return 92;
        }
        if (type == 2014) {
            return 93;
        }
        return super.getPreferredType(type);
    }

    @Override
    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        super.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
        if (lhsxml) {
            this.appendXmlValue(buf, lhs);
        } else {
            lhs.appendTo(buf);
        }
        buf.append(" ").append(op).append(" ");
        if (rhsxml) {
            this.appendXmlValue(buf, rhs);
        } else {
            rhs.appendTo(buf);
        }
    }

    private void appendXmlValue(SQLBuffer buf, FilterValue val) {
        buf.append("ExtractValue(").append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append(",'/*/");
        val.appendTo(buf);
        buf.append("')");
    }

    @Override
    public int getBatchFetchSize(int batchFetchSize) {
        return Integer.MIN_VALUE;
    }

    @Override
    public String getSelectOperation(JDBCFetchConfiguration fetch) {
        Object hint = fetch == null ? null : fetch.getHint(SELECT_HINT);
        String select = "SELECT";
        if (hint != null) {
            select = select + " " + hint;
        }
        return select;
    }

    @Override
    protected Collection<String> getSelectTableAliases(Select sel) {
        HashSet<String> result = new HashSet<String>();
        List selects = sel.getIdentifierAliases();
        for (String s : selects) {
            String tableAlias = s.substring(0, s.indexOf(46));
            result.add(tableAlias);
        }
        return result;
    }

    @Override
    protected int matchErrorState(Map<Integer, Set<String>> errorStates, SQLException ex) {
        SQLException sqle;
        int state = super.matchErrorState(errorStates, ex);
        if (state == 0 && ex.getErrorCode() == 0 && ex.getSQLState() == null && (sqle = ex.getNextException()) != null && sqle.toString().startsWith("com.mysql.jdbc.exceptions.MySQLTimeoutException")) {
            state = this.conf != null && this.conf.getLockTimeout() != -1 ? 1 : 6;
        }
        return state;
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        if (subtype == 1 && ex.getErrorCode() == 1205 || subtype == 6 && ex.getErrorCode() == 1317) {
            return false;
        }
        if (ex.getErrorCode() == 0 && ex.getSQLState() == null) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }

    @Override
    public String getTypeName(Column col) {
        if (col.getType() == 2004 && col.getTypeIdentifier().getType() == DBIdentifier.DBIdentifierType.NULL) {
            if (col.getSize() <= 0) {
                return this.blobTypeName;
            }
            if (col.getSize() <= 255) {
                return tinyBlobTypeName;
            }
            if (col.getSize() <= 65535) {
                return this.blobTypeName;
            }
            if (col.getSize() <= 0xFFFFFF) {
                return mediumBlobTypeName;
            }
            return longBlobTypeName;
        }
        if (col.getType() == 2005 && col.getTypeIdentifier().getType() == DBIdentifier.DBIdentifierType.NULL) {
            if (col.getSize() <= 0) {
                return this.clobTypeName;
            }
            if (col.getSize() <= 255) {
                return tinyTextTypeName;
            }
            if (col.getSize() <= 65535) {
                return this.clobTypeName;
            }
            if (col.getSize() <= 0xFFFFFF) {
                return mediumTextTypeName;
            }
            return longTextTypeName;
        }
        return super.getTypeName(col);
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("LOCATE(");
        find.appendTo(buf);
        buf.append(", ");
        str.appendTo(buf);
        if (start != null) {
            buf.append(", ");
            start.appendTo(buf);
        }
        buf.append(")");
    }
}

