/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSearchByRole
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserSearchByRole.class);
    private static final String SEARCH_HELP_MESSAGE = "user --search-by-role {REALM} {ROLE-KEY}";
    private final Input input;

    public UserSearchByRole(Input input) {
        this.input = input;
    }

    public void search() {
        block6: {
            if (this.input.parameterNumber() == 2) {
                String realm = this.input.firstParameter();
                String role = this.input.secondParameter();
                try {
                    List<UserTO> userTOs;
                    if (!this.realmSyncopeOperations.exists(realm)) {
                        this.userResultManager.genericMessage("Operation performed on root realm because " + realm + " does not exists");
                    }
                    if ((userTOs = this.userSyncopeOperations.searchByRole(realm, this.input.secondParameter())) == null || userTOs.isEmpty()) {
                        this.userResultManager.genericMessage("No users has " + role + " assigned");
                        break block6;
                    }
                    this.userResultManager.printUsers(userTOs);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error searching user", ex);
                    this.userResultManager.genericError(ex.getMessage());
                    this.userResultManager.genericError(SEARCH_HELP_MESSAGE);
                }
            } else {
                this.userResultManager.commandOptionError(SEARCH_HELP_MESSAGE);
            }
        }
    }
}

