/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.schema.SchemaDelete;
import org.apache.syncope.client.cli.commands.schema.SchemaDetails;
import org.apache.syncope.client.cli.commands.schema.SchemaList;
import org.apache.syncope.client.cli.commands.schema.SchemaListAll;
import org.apache.syncope.client.cli.commands.schema.SchemaListDerived;
import org.apache.syncope.client.cli.commands.schema.SchemaListPlain;
import org.apache.syncope.client.cli.commands.schema.SchemaListVirtual;
import org.apache.syncope.client.cli.commands.schema.SchemaRead;
import org.apache.syncope.client.cli.commands.schema.SchemaResultManager;

@Command(name="schema")
public class SchemaCommand
extends AbstractCommand {
    private final SchemaResultManager schemaResultManager = new SchemaResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case DETAILS: {
                new SchemaDetails(input).details();
                break;
            }
            case LIST: {
                new SchemaList(input).list();
                break;
            }
            case LIST_ALL: {
                new SchemaListAll(input).listAll();
                break;
            }
            case LIST_PLAIN: {
                new SchemaListPlain(input).listPlain();
                break;
            }
            case LIST_DERIVED: {
                new SchemaListDerived(input).listDerived();
                break;
            }
            case LIST_VIRTUAL: {
                new SchemaListVirtual(input).listVirtual();
                break;
            }
            case READ: {
                new SchemaRead(input).read();
                break;
            }
            case DELETE: {
                new SchemaDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.schemaResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.schemaResultManager.commandHelpMessage(this.getClass());
    }

    private static enum Options {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        LIST_ALL("--list-all"),
        LIST_PLAIN("--list-plain"),
        LIST_DERIVED("--list-derived"),
        LIST_VIRTUAL("--list-virtual"),
        READ("--read"),
        DELETE("--delete");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

