/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.role;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.role.RoleDelete;
import org.apache.syncope.client.cli.commands.role.RoleDetails;
import org.apache.syncope.client.cli.commands.role.RoleList;
import org.apache.syncope.client.cli.commands.role.RoleRead;
import org.apache.syncope.client.cli.commands.role.RoleResultManager;

@Command(name="role")
public class RoleCommand
extends AbstractCommand {
    private final RoleResultManager roleResultManager = new RoleResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(RoleOptions.HELP.getOptionName());
        }
        switch (RoleOptions.fromName(input.getOption())) {
            case DETAILS: {
                new RoleDetails(input).details();
                break;
            }
            case LIST: {
                new RoleList(input).list();
                break;
            }
            case READ: {
                new RoleRead(input).read();
                break;
            }
            case DELETE: {
                new RoleDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.roleResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.roleResultManager.commandHelpMessage(this.getClass());
    }

    public static enum RoleOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        READ("--read"),
        DELETE("--delete");

        private final String optionName;

        private RoleOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static RoleOptions fromName(String name) {
            RoleOptions optionToReturn = HELP;
            for (RoleOptions option : RoleOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (RoleOptions value : RoleOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

