/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ReportTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRead
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRead.class);
    private static final String READ_HELP_MESSAGE = "report --read {REPORT-KEY} {REPORT-KEY} [...]";
    private final Input input;

    public ReportRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() >= 1) {
            ArrayList<ReportTO> reportTOs = new ArrayList<ReportTO>();
            for (String parameter : this.input.getParameters()) {
                try {
                    reportTOs.add(this.reportSyncopeOperations.read(parameter));
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading report", (Throwable)ex);
                    this.reportResultManager.numberFormatException("report", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading report", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.reportResultManager.notFoundError("Report", parameter);
                        continue;
                    }
                    this.reportResultManager.genericError(ex.getMessage());
                }
            }
            this.reportResultManager.printReports(reportTOs);
        } else {
            this.reportResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

