/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.List;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.JobTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportListJobs
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportListJobs.class);
    private static final String LIST_HELP_MESSAGE = "report --list-jobs";
    private final Input input;

    public ReportListJobs(Input input) {
        this.input = input;
    }

    public void list() {
        block5: {
            if (this.input.parameterNumber() == 0) {
                try {
                    List<JobTO> jobs = this.reportSyncopeOperations.listJobs();
                    if (jobs.isEmpty()) {
                        this.reportResultManager.genericMessage("There are NO jobs available");
                        break block5;
                    }
                    this.reportResultManager.printJobs(jobs);
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error listing report", (Throwable)ex);
                    this.reportResultManager.genericError(ex.getMessage());
                }
            } else {
                this.reportResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
            }
        }
    }
}

