/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.logger.LoggerCreate;
import org.apache.syncope.client.cli.commands.logger.LoggerDelete;
import org.apache.syncope.client.cli.commands.logger.LoggerDetails;
import org.apache.syncope.client.cli.commands.logger.LoggerLastStatements;
import org.apache.syncope.client.cli.commands.logger.LoggerList;
import org.apache.syncope.client.cli.commands.logger.LoggerListMemoryAppenders;
import org.apache.syncope.client.cli.commands.logger.LoggerRead;
import org.apache.syncope.client.cli.commands.logger.LoggerResultManager;
import org.apache.syncope.client.cli.commands.logger.LoggerUpdate;
import org.apache.syncope.client.cli.commands.logger.LoggerUpdateAll;

@Command(name="logger")
public class LoggerCommand
extends AbstractCommand {
    private final LoggerResultManager loggerResultManager = new LoggerResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(LoggerOptions.HELP.getOptionName());
        }
        switch (LoggerOptions.fromName(input.getOption())) {
            case DETAILS: {
                new LoggerDetails(input).details();
                break;
            }
            case LIST: {
                new LoggerList(input).list();
                break;
            }
            case LIST_MEMORY_APPENDERS: {
                new LoggerListMemoryAppenders(input).list();
                break;
            }
            case LAST_STATEMENTS: {
                new LoggerLastStatements(input).read();
                break;
            }
            case READ: {
                new LoggerRead(input).read();
                break;
            }
            case UPDATE: {
                new LoggerUpdate(input).update();
                break;
            }
            case UPDATE_ALL: {
                new LoggerUpdateAll(input).updateAll();
                break;
            }
            case CREATE: {
                new LoggerCreate(input).create();
                break;
            }
            case DELETE: {
                new LoggerDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.loggerResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.loggerResultManager.commandHelpMessage(this.getClass());
    }

    public static enum LoggerOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST_MEMORY_APPENDERS("--list-memory-appenders"),
        LAST_STATEMENTS("--last-statements"),
        LIST("--list"),
        READ("--read"),
        UPDATE("--update"),
        UPDATE_ALL("--update-all"),
        CREATE("--create"),
        DELETE("--delete");

        private final String optionName;

        private LoggerOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static LoggerOptions fromName(String name) {
            LoggerOptions optionToReturn = HELP;
            for (LoggerOptions option : LoggerOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (LoggerOptions value : LoggerOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

