/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.entitlement;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.cli.commands.role.RoleSyncopeOperations;
import org.apache.syncope.client.cli.commands.user.UserSyncopeOperations;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;

public class EntitlementSyncopeOperations {
    private final PlatformInfo platformInfo = SyncopeServices.get(SyncopeService.class).platform();
    private final UserSyncopeOperations userSyncopeOperations = new UserSyncopeOperations();
    private final RoleSyncopeOperations roleSyncopeOperations = new RoleSyncopeOperations();

    public Set<String> list() {
        return this.platformInfo.getEntitlements();
    }

    public boolean exists(String entitlement) {
        return this.list().contains(entitlement);
    }

    public Set<String> usernameEntitlements(String username) {
        TreeSet<String> entitlements = new TreeSet<String>();
        UserTO userTO = this.userSyncopeOperations.read(username);
        for (String role : userTO.getRoles()) {
            entitlements.addAll(this.roleSyncopeOperations.read(role).getEntitlements());
        }
        return entitlements;
    }

    public Set<String> userIdEntitlements(String userId) {
        TreeSet<String> entitlements = new TreeSet<String>();
        UserTO userTO = this.userSyncopeOperations.read(userId);
        for (String role : userTO.getRoles()) {
            entitlements.addAll(this.roleSyncopeOperations.read(role).getEntitlements());
        }
        return entitlements;
    }

    public Set<String> entitlementsPerRole(String roleId) {
        return this.roleSyncopeOperations.read(roleId).getEntitlements();
    }

    public Set<RoleTO> rolePerEntitlements(String entitlement) {
        HashSet<RoleTO> roles = new HashSet<RoleTO>();
        for (RoleTO role : this.roleSyncopeOperations.list()) {
            if (!role.getEntitlements().contains(entitlement)) continue;
            roles.add(role);
        }
        return roles;
    }
}

