/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.domain.DomainDelete;
import org.apache.syncope.client.cli.commands.domain.DomainDetails;
import org.apache.syncope.client.cli.commands.domain.DomainList;
import org.apache.syncope.client.cli.commands.domain.DomainResultManager;

@Command(name="domain")
public class DomainCommand
extends AbstractCommand {
    private final DomainResultManager domainResultManager = new DomainResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case DETAILS: {
                new DomainDetails(input).details();
                break;
            }
            case LIST: {
                new DomainList(input).list();
                break;
            }
            case DELETE: {
                new DomainDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                new DomainResultManager().deletedMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.domainResultManager.commandHelpMessage(this.getClass());
    }

    private static enum Options {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        DELETE("--delete");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

