/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.configuration;

import java.io.InputStream;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.configuration.AbstractConfigurationCommand;
import org.apache.syncope.client.cli.util.XMLUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationExport
extends AbstractConfigurationCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationExport.class);
    private static final String EXPORT_HELP_MESSAGE = "configuration --export {WHERE-DIR}";
    private static final String EXPORT_FILE_NAME = "/content.xml";
    private final Input input;

    public ConfigurationExport(Input input) {
        this.input = input;
    }

    public void export() {
        if (this.input.parameterNumber() == 1) {
            try {
                XMLUtils.createXMLFile((InputStream)this.configurationSyncopeOperations.export().getEntity(), this.input.firstParameter() + EXPORT_FILE_NAME);
                this.configurationResultManager.genericMessage(this.input.firstParameter() + EXPORT_FILE_NAME + " successfully created");
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error exporting configuration", (Throwable)ex);
                this.configurationResultManager.genericError("Error calling configuration service " + ex.getMessage());
            }
            catch (Exception ex) {
                LOG.error("Error exporting configuration", (Throwable)ex);
                this.configurationResultManager.genericError(ex.getMessage());
            }
        } else {
            this.configurationResultManager.commandOptionError(EXPORT_HELP_MESSAGE);
        }
    }
}

