/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.view;

import java.util.List;
import java.util.ResourceBundle;

public final class Messages {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("messages");
    private static final String OPTION_COMMAND_MESSAGE_TEMPLATE = "%n - Usage: %s%n";
    private static final String CREATED_MESSAGE_TEMPLATE = "%s %s successfully created";
    private static final String UPDATED_MESSAGE_TEMPLATE = "%s %s successfully updated";
    private static final String DELETED_MESSAGE_TEMPLATE = "%s %s successfully deleted";
    private static final String DOESNT_EXIST_MESSAGE_TEMPLATE = "%s %s doesn't exist";
    private static final String TYPE_NOT_VALID_MESSAGE_TEMPLATE = "%s isn't a valid %s type, try with: %s";
    private static final String ID_NOT_NUMBER_MESSAGE_TEMPLATE = "Error reading %s. It isn't a valid %s id because it isn't a long value";
    private static final String NOT_BOOLEAN_MESSAGE_TEMPLATE = "Error reading %s. It isn't a valid %s value because it isn't a boolean value";
    private static final String DEFAULT_MESSAGE_TEMPLATE = "%s is not a valid option. %n\b %s";

    public static void printCommandOptionMessage(String message) {
        System.out.println(String.format(OPTION_COMMAND_MESSAGE_TEMPLATE, message));
    }

    public static void printMessage(String ... messages) {
        StringBuilder messageBuilder = new StringBuilder("\n");
        for (String message : messages) {
            messageBuilder.append(" - ").append(message).append("\n");
        }
        System.out.println(messageBuilder.toString());
    }

    public static void printNofFoundMessage(String what, String key) {
        Messages.printMessage(String.format(DOESNT_EXIST_MESSAGE_TEMPLATE, what, key));
    }

    public static void printCreatedMessage(String what, String key) {
        Messages.printMessage(String.format(CREATED_MESSAGE_TEMPLATE, what, key));
    }

    public static void printUpdatedMessage(String what, String key) {
        Messages.printMessage(String.format(UPDATED_MESSAGE_TEMPLATE, what, key));
    }

    public static void printDeletedMessage(String what, String key) {
        Messages.printMessage(String.format(DELETED_MESSAGE_TEMPLATE, what, key));
    }

    public static void printIdNotNumberDeletedMessage(String what, String key) {
        Messages.printMessage(String.format(ID_NOT_NUMBER_MESSAGE_TEMPLATE, key, what));
    }

    public static void printNotBooleanDeletedMessage(String what, String key) {
        Messages.printMessage(String.format(NOT_BOOLEAN_MESSAGE_TEMPLATE, key, what));
    }

    public static void printTypeNotValidMessage(String what, String key, String[] types) {
        StringBuilder typesBuilder = new StringBuilder();
        for (String type : types) {
            typesBuilder.append("\n     *** ").append(type);
        }
        Messages.printMessage(String.format(TYPE_NOT_VALID_MESSAGE_TEMPLATE, key, what, typesBuilder.toString()));
    }

    public static void printDefaultMessage(String option, String helpMessage) {
        Messages.printMessage(String.format(DEFAULT_MESSAGE_TEMPLATE, option, helpMessage));
    }

    public static void printUnnecessaryParameters(List<String> parameters, String helpMessage) {
        Messages.printMessage("Unnecessary parameter: " + parameters, "Usage: " + helpMessage);
    }

    public static String commandHelpMessage(String name) {
        return MESSAGES.getString(name + ".help.message");
    }

    private Messages() {
    }
}

