/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskList
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskList.class);
    private static final String LIST_HELP_MESSAGE = "task --list {TASK-TYPE}\n   Task type: NOTIFICATION / PROPAGATION / PUSH / SCHEDULED / PULL";
    private final Input input;

    public TaskList(Input input) {
        this.input = input;
    }

    public void list() {
        if (this.input.parameterNumber() == 1) {
            try {
                this.taskResultManager.printTasksType(this.input.firstParameter(), this.taskSyncopeOperations.list(this.input.firstParameter()));
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error listing task", (Throwable)ex);
                this.taskResultManager.genericError(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Error listing task", (Throwable)ex);
                this.taskResultManager.typeNotValidError("task", this.input.firstParameter(), CommandUtils.fromEnumToArray(TaskType.class));
            }
        } else {
            this.taskResultManager.commandOptionError(LIST_HELP_MESSAGE);
        }
    }
}

