/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import java.util.Arrays;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecute
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecute.class);
    private static final String EXECUTE_HELP_MESSAGE = "task --execute {TASK-KEY} {DRY-RUN}\n          Dry run: true / false";
    private final Input input;

    public TaskExecute(Input input) {
        this.input = input;
    }

    public void execute() {
        block11: {
            if (this.input.parameterNumber() == 2) {
                try {
                    boolean dryRun = true;
                    if ("false".equalsIgnoreCase(this.input.secondParameter())) {
                        dryRun = false;
                    } else if ("true".equalsIgnoreCase(this.input.secondParameter())) {
                        dryRun = true;
                    } else {
                        this.taskResultManager.notBooleanDeletedError("dry run", this.input.secondParameter());
                    }
                    this.taskResultManager.printTaskExecTOs(Arrays.asList(this.taskSyncopeOperations.execute(this.input.firstParameter(), dryRun)));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error executing task", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.taskResultManager.notFoundError("Task", this.input.firstParameter());
                        break block11;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.taskResultManager.genericError("You cannot delete task " + this.input.firstParameter());
                        break block11;
                    }
                    this.taskResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error executing task", (Throwable)ex);
                    this.taskResultManager.notBooleanDeletedError("task", this.input.firstParameter());
                }
            } else {
                this.taskResultManager.commandOptionError(EXECUTE_HELP_MESSAGE);
            }
        }
    }
}

