/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.cli.util.XMLUtils;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.syncope.common.rest.api.beans.ExecuteQuery;
import org.apache.syncope.common.rest.api.service.ReportService;

public class ReportSyncopeOperations {
    private final ReportService reportService = SyncopeServices.get(ReportService.class);

    public ReportTO read(String reportKey) {
        return this.reportService.read(reportKey);
    }

    public List<JobTO> listJobs() {
        return this.reportService.listJobs();
    }

    public List<ReportTO> list() {
        return this.reportService.list();
    }

    public String exportExecutionResult(String executionKey, String reportExecExportFormat) throws Exception {
        ReportExecExportFormat format = ReportExecExportFormat.valueOf((String)reportExecExportFormat);
        SequenceInputStream report = (SequenceInputStream)this.reportService.exportExecutionResult(executionKey, format).getEntity();
        String fileName = "export_" + executionKey;
        OutputStream os = null;
        switch (format) {
            case XML: {
                fileName = fileName + ".xml";
                XMLUtils.createXMLFile(report, fileName);
                break;
            }
            case CSV: {
                fileName = fileName + ".csv";
                os = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                IOUtils.copyAndCloseInput((InputStream)report, (OutputStream)os);
                break;
            }
            case PDF: {
                fileName = fileName + ".pdf";
                os = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                IOUtils.copyAndCloseInput((InputStream)report, (OutputStream)os);
                break;
            }
            case HTML: {
                fileName = fileName + ".html";
                os = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                IOUtils.copyAndCloseInput((InputStream)report, (OutputStream)os);
                break;
            }
            case RTF: {
                fileName = fileName + ".rtf";
                os = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                IOUtils.copyAndCloseInput((InputStream)report, (OutputStream)os);
                break;
            }
            default: {
                return format + " not supported";
            }
        }
        if (os != null) {
            os.close();
        }
        return fileName;
    }

    public void execute(String reportKey) {
        this.reportService.execute(new ExecuteQuery.Builder().key(reportKey).build());
    }

    public void deleteExecution(String executionKey) {
        this.reportService.deleteExecution(executionKey);
    }

    public void delete(String reportKey) {
        this.reportService.delete(reportKey);
    }
}

