/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;

public class ReportResultManager
extends CommonsResultManager {
    public void printReports(List<ReportTO> reportTOs) {
        System.out.println("");
        reportTOs.forEach(reportTO -> this.printReport((ReportTO)reportTO));
    }

    private void printReport(ReportTO reportTO) {
        System.out.println(" > REPORT KEY: " + reportTO.getKey());
        System.out.println("    name: " + reportTO.getName());
        System.out.println("    cron expression: " + reportTO.getCronExpression());
        System.out.println("    latest execution status: " + reportTO.getLatestExecStatus());
        System.out.println("    start date: " + reportTO.getStart());
        System.out.println("    end date: " + reportTO.getEnd());
        System.out.println("    CONF:");
        reportTO.getReportlets().forEach(reportlet -> System.out.println("       name: " + reportlet));
        System.out.println("    EXECUTIONS:");
        this.printReportExecutions(reportTO.getExecutions());
        System.out.println("");
    }

    public void printReportExecutions(List<ExecTO> reportExecTOs) {
        reportExecTOs.forEach(reportExecTO -> {
            System.out.println("       REPORT EXEC KEY: " + reportExecTO.getKey());
            System.out.println("       status: " + reportExecTO.getStatus());
            System.out.println("       message: " + reportExecTO.getMessage());
            System.out.println("       start date: " + reportExecTO.getStart());
            System.out.println("       end date: " + reportExecTO.getEnd());
            System.out.println("       report: " + reportExecTO.getRefDesc());
        });
    }

    public void printJobs(List<JobTO> jobTOs) {
        jobTOs.forEach(jobTO -> {
            System.out.println("       REPORT: " + jobTO.getRefDesc());
            System.out.println("       start date: " + jobTO.getStart());
            System.out.println("       running: " + jobTO.isRunning());
            System.out.println("       scheduled: " + jobTO.isScheduled());
        });
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("reports details", details);
    }
}

