/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDeleteExecution
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDeleteExecution.class);
    private static final String DELETE_EXECUTION_HELP_MESSAGE = "report --delete-execution {EXECUTION-KEY} {EXECUTION-KEY} [...]";
    private final Input input;

    public ReportDeleteExecution(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.reportSyncopeOperations.deleteExecution(parameter);
                    this.reportResultManager.deletedMessage("Report execution", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting execution", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.reportResultManager.notFoundError("Report", parameter);
                        continue;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.reportResultManager.genericError("You cannot delete report " + parameter);
                        continue;
                    }
                    this.reportResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting execution", (Throwable)ex);
                    this.reportResultManager.numberFormatException("report", parameter);
                }
            }
        } else {
            this.reportResultManager.commandOptionError(DELETE_EXECUTION_HELP_MESSAGE);
        }
    }
}

