/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.report.AbstractReportCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDelete
extends AbstractReportCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDelete.class);
    private static final String DELETE_HELP_MESSAGE = "report --delete {REPORT-KEY} {REPORT-KEY} [...]";
    private final Input input;

    public ReportDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.reportSyncopeOperations.delete(parameter);
                    this.reportResultManager.deletedMessage("Report", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting report", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.reportResultManager.notFoundError("Report", parameter);
                        continue;
                    }
                    if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.reportResultManager.genericError("You cannot delete report " + parameter);
                        continue;
                    }
                    this.reportResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error deleting report", (Throwable)ex);
                    this.reportResultManager.numberFormatException("report", parameter);
                }
            }
        } else {
            this.reportResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

