/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUpdateAll
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerUpdateAll.class);
    private static final String UPDATE_ALL_HELP_MESSAGE = "logger --update-all {LOG-LEVEL}";
    private final Input input;

    public LoggerUpdateAll(Input input) {
        this.input = input;
    }

    public void updateAll() {
        if (this.input.parameterNumber() == 1) {
            ArrayList<LoggerTO> loggerTOs = new ArrayList<LoggerTO>();
            boolean failed = false;
            for (LoggerTO loggerTO : this.loggerSyncopeOperations.list()) {
                try {
                    loggerTO.setLevel(LoggerLevel.valueOf((String)this.input.firstParameter()));
                    this.loggerSyncopeOperations.update(loggerTO);
                    loggerTOs.add(loggerTO);
                }
                catch (IllegalArgumentException | WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error updating logger", ex);
                    if (ex.getMessage().startsWith("No enum constant org.apache.syncope.common.lib.types.")) {
                        this.loggerResultManager.typeNotValidError("logger level", this.input.firstParameter(), CommandUtils.fromEnumToArray(LoggerLevel.class));
                    } else {
                        this.loggerResultManager.genericError(ex.getMessage());
                        this.loggerResultManager.genericError(UPDATE_ALL_HELP_MESSAGE);
                    }
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                this.loggerResultManager.fromUpdate(loggerTOs);
            }
        } else {
            this.loggerResultManager.commandOptionError(UPDATE_ALL_HELP_MESSAGE);
        }
    }
}

