/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUpdate
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerUpdate.class);
    private static final String UPDATE_HELP_MESSAGE = "logger --update {LOG-NAME}={LOG-LEVEL} {LOG-NAME}={LOG-LEVEL} [...]";
    private final Input input;

    public LoggerUpdate(Input input) {
        this.input = input;
    }

    public void update() {
        if (this.input.parameterNumber() >= 1) {
            ArrayList<LoggerTO> loggerTOs = new ArrayList<LoggerTO>();
            boolean failed = false;
            for (String parameter : this.input.getParameters()) {
                Pair<String, String> pairParameter = Input.toPairParameter(parameter);
                try {
                    LoggerTO loggerTO = this.loggerSyncopeOperations.read((String)pairParameter.getKey());
                    loggerTO.setLevel(LoggerLevel.valueOf((String)((String)pairParameter.getValue())));
                    this.loggerSyncopeOperations.update(loggerTO);
                    loggerTOs.add(loggerTO);
                }
                catch (IllegalArgumentException | WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error updating logger", ex);
                    if (ex.getMessage().startsWith("No enum constant org.apache.syncope.common.lib.types.")) {
                        this.loggerResultManager.typeNotValidError("logger level", this.input.firstParameter(), CommandUtils.fromEnumToArray(LoggerLevel.class));
                    } else if ("Parameter syntax error!".equalsIgnoreCase(ex.getMessage())) {
                        this.loggerResultManager.genericError(ex.getMessage());
                        this.loggerResultManager.genericError(UPDATE_HELP_MESSAGE);
                    } else if (ex.getMessage().startsWith("NotFound")) {
                        this.loggerResultManager.notFoundError("Logger", parameter);
                    } else {
                        this.loggerResultManager.genericError(ex.getMessage());
                        this.loggerResultManager.genericError(UPDATE_HELP_MESSAGE);
                    }
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                this.loggerResultManager.fromUpdate(loggerTOs);
            }
        } else {
            this.loggerResultManager.commandOptionError(UPDATE_HELP_MESSAGE);
        }
    }
}

