/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.logger.AbstractLoggerCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerCreate
extends AbstractLoggerCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerCreate.class);
    private static final String CREATE_HELP_MESSAGE = "logger --create {LOG-NAME}={LOG-LEVEL} {LOG-NAME}={LOG-LEVEL} [...]";
    private final Input input;

    public LoggerCreate(Input input) {
        this.input = input;
    }

    public void create() {
        if (this.input.parameterNumber() >= 1) {
            ArrayList<LoggerTO> loggerTOs = new ArrayList<LoggerTO>();
            boolean failed = false;
            for (String parameter : this.input.getParameters()) {
                LoggerTO loggerTO = new LoggerTO();
                Pair<String, String> pairParameter = Input.toPairParameter(parameter);
                try {
                    loggerTO.setKey((String)pairParameter.getKey());
                    loggerTO.setLevel(LoggerLevel.valueOf((String)((String)pairParameter.getValue())));
                    this.loggerSyncopeOperations.update(loggerTO);
                    loggerTOs.add(loggerTO);
                }
                catch (IllegalArgumentException | WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error creating logger", ex);
                    this.loggerResultManager.typeNotValidError("logger level", this.input.firstParameter(), CommandUtils.fromEnumToArray(LoggerLevel.class));
                    failed = true;
                    break;
                }
            }
            if (!failed) {
                this.loggerResultManager.fromUpdate(loggerTOs);
            }
        } else {
            this.loggerResultManager.commandOptionError(CREATE_HELP_MESSAGE);
        }
    }
}

