/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.entitlement;

import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.entitlement.AbstractEntitlementCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RoleTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitlementListRole
extends AbstractEntitlementCommand {
    private static final Logger LOG = LoggerFactory.getLogger(EntitlementListRole.class);
    private static final String READ_HELP_MESSAGE = "entitlement --list-role {ENTITLEMENT-NAME}";
    private final Input input;

    public EntitlementListRole(Input input) {
        this.input = input;
    }

    public void list() {
        block8: {
            if (this.input.getParameters().length == 1) {
                try {
                    Set<RoleTO> roleTOs = this.entitlementSyncopeOperations.rolePerEntitlements(this.input.firstParameter());
                    if (!this.entitlementSyncopeOperations.exists(this.input.firstParameter())) {
                        this.entitlementResultManager.notFoundError("Entitlement", this.input.firstParameter());
                        break block8;
                    }
                    if (roleTOs != null && !roleTOs.isEmpty()) {
                        this.entitlementResultManager.rolesToView(roleTOs);
                        break block8;
                    }
                    this.entitlementResultManager.genericMessage("No roles found for entitlement " + this.input.firstParameter());
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading entitlement", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.entitlementResultManager.notFoundError("User", this.input.firstParameter());
                        break block8;
                    }
                    this.entitlementResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading entitlement", (Throwable)ex);
                    this.entitlementResultManager.numberFormatException("user", this.input.firstParameter());
                }
            } else {
                this.entitlementResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

