/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.connector;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.connector.AbstractConnectorCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorListConfigurationProperties
extends AbstractConnectorCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorListConfigurationProperties.class);
    private static final String LIST_CONFIGURATION_HELP_MESSAGE = "connector --list-configuration-properties {CONNECTOR-KEY} {CONNECTOR-KEY} [...]";
    private final Input input;

    public ConnectorListConfigurationProperties(Input input) {
        this.input = input;
    }

    public void list() {
        if (this.input.getParameters().length >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.connectorResultManager.printConfigurationProperties(this.connectorSyncopeOperations.read(parameter).getConf());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error listening connector", (Throwable)ex);
                    this.connectorResultManager.numberFormatException("connector", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error listening connector", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.connectorResultManager.notFoundError("Connector", parameter);
                        continue;
                    }
                    this.connectorResultManager.genericError(ex.getMessage());
                }
            }
        } else {
            this.connectorResultManager.commandOptionError(LIST_CONFIGURATION_HELP_MESSAGE);
        }
    }
}

