/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.anyobject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AttrTO;

public class AnyObjectResultManager
extends CommonsResultManager {
    public void printAnys(List<AnyObjectTO> anyObjectTOs) {
        System.out.println("");
        for (AnyObjectTO anyObjectTO : anyObjectTOs) {
            this.printAny(anyObjectTO);
        }
    }

    public void printAny(AnyObjectTO anyObjectTO) {
        System.out.println(" > ANY OBJECT KEY: " + anyObjectTO.getKey());
        System.out.println("    type: " + anyObjectTO.getType());
        System.out.println("    realm: " + anyObjectTO.getRealm());
        System.out.println("    status: " + anyObjectTO.getStatus());
        System.out.println("    RESOURCES: ");
        this.printResources(anyObjectTO.getResources());
        System.out.println("    PLAIN ATTRIBUTES: ");
        this.printAttributes(anyObjectTO.getPlainAttrs());
        System.out.println("    DERIVED ATTRIBUTES: ");
        this.printAttributes(anyObjectTO.getDerAttrs());
        System.out.println("    VIRTUAL ATTRIBUTES: ");
        this.printAttributes(anyObjectTO.getVirAttrs());
    }

    private void printResources(Set<String> resources) {
        for (String resource : resources) {
            System.out.println("      - " + resource);
        }
    }

    public void printAttributes(Set<AttrTO> attributes) {
        for (AttrTO attribute : attributes) {
            this.printAttribute(attribute);
        }
        System.out.println("");
    }

    public void printAttribute(AttrTO attribute) {
        StringBuilder attributeMessageBuilder = new StringBuilder();
        attributeMessageBuilder.append("     - ").append(attribute.getSchema()).append(": ").append(attribute.getValues());
        System.out.println(attributeMessageBuilder.toString());
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("groups details", details);
    }
}

