/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.anyobject;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.anyobject.AbstractAnyObjectCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyObjectDelete
extends AbstractAnyObjectCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AnyObjectDelete.class);
    private static final String DELETE_HELP_MESSAGE = "any --delete {ANY_OBJECT-KEY} {ANY_OBJECT-KEY} [...]";
    private final Input input;

    public AnyObjectDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.anySyncopeOperations.delete(parameter);
                    this.anyResultManager.deletedMessage("Any", parameter);
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error deleting group", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.anyResultManager.notFoundError("any", parameter);
                        continue;
                    }
                    this.anyResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.anyResultManager.numberFormatException("any", parameter);
                }
            }
        } else {
            this.anyResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

