/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.anyobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.anyobject.AnyObjectDelete;
import org.apache.syncope.client.cli.commands.anyobject.AnyObjectList;
import org.apache.syncope.client.cli.commands.anyobject.AnyObjectRead;
import org.apache.syncope.client.cli.commands.anyobject.AnyObjectReadAttributeBySchemaTypeAndSchemaKey;
import org.apache.syncope.client.cli.commands.anyobject.AnyObjectReadAttributesBySchemaType;
import org.apache.syncope.client.cli.commands.anyobject.AnyObjectResultManager;

@Command(name="anyObject")
public class AnyObjectCommand
extends AbstractCommand {
    private final AnyObjectResultManager anyObjectResultManager = new AnyObjectResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(AnyObjectOptions.HELP.getOptionName());
        }
        switch (AnyObjectOptions.fromName(input.getOption())) {
            case DETAILS: {
                break;
            }
            case LIST: {
                new AnyObjectList(input).list();
                break;
            }
            case READ: {
                new AnyObjectRead(input).read();
                break;
            }
            case READ_ATTRIBUTES_BY_SCHEMA: {
                new AnyObjectReadAttributeBySchemaTypeAndSchemaKey(input).read();
                break;
            }
            case READ_ATTRIBUTES_BY_SCHEMA_TYPE: {
                new AnyObjectReadAttributesBySchemaType(input).read();
                break;
            }
            case DELETE: {
                new AnyObjectDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.anyObjectResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.anyObjectResultManager.commandHelpMessage(this.getClass());
    }

    private static enum AnyObjectOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        READ("--read"),
        READ_ATTRIBUTES_BY_SCHEMA("--read-attr-by-schema"),
        READ_ATTRIBUTES_BY_SCHEMA_TYPE("--read-attr-by-schema-type"),
        DELETE("--delete");

        private final String optionName;

        private AnyObjectOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static AnyObjectOptions fromName(String name) {
            AnyObjectOptions optionToReturn = HELP;
            for (AnyObjectOptions option : AnyObjectOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (AnyObjectOptions value : AnyObjectOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

