/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerLevel;

public final class LoggerWrapper {
    private LoggerWrapper() {
    }

    public static List<AuditLoggerName> wrap(Collection<LoggerTO> logger) {
        ArrayList<AuditLoggerName> result = new ArrayList<AuditLoggerName>();
        logger.forEach(loggerTO -> {
            try {
                result.add(AuditLoggerName.fromLoggerName((String)loggerTO.getKey()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return result;
    }

    public static List<LoggerTO> unwrap(Collection<AuditLoggerName> auditNames) {
        return auditNames.stream().map(name -> {
            LoggerTO loggerTO = new LoggerTO();
            loggerTO.setKey(name.toLoggerName());
            loggerTO.setLevel(LoggerLevel.DEBUG);
            return loggerTO;
        }).collect(Collectors.toList());
    }
}

