/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.provisioning.api.data;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;

public interface AccessTokenDataBinder {

    Pair<String, Date> generateJWT(String tokenId, String subject, long duration, Map<String, Object> claims);

    Pair<String, Date> create(String subject, Map<String, Object> claims, byte[] authorities, boolean replace);

    Pair<String, Date> update(AccessToken accessToken, byte[] authorities);

    AccessTokenTO getAccessTokenTO(AccessToken accessToken);

}
