/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.client.console.chartjs;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;

/**
 * Builds the bridge between wicket and chart.js' javascript.
 */
public class ChartJSBehavior extends AbstractDefaultAjaxBehavior {

    private static final long serialVersionUID = 5935294904099227859L;

    @Override
    protected void respond(final AjaxRequestTarget target) {
    }

    @Override
    public void renderHead(final Component component, final IHeaderResponse response) {
        super.renderHead(component, response);

        response.render(OnDomReadyHeaderItem.forScript(
                "WicketCharts['" + component.getMarkupId() + "']=buildChart('" + component.getMarkupId() + "');"));

        if (component.getParent() instanceof ChartJSPanel) {
            response.render(OnDomReadyHeaderItem.forScript(((ChartJSPanel) component.getParent()).generateChart()));
        }
    }
}
