/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.IHTMLColorConstants;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.JavaWordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class JavaScriptScanner
extends RuleBasedScanner {
    public static final String[] KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "prototype", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with", "typeof", "yield", "undefined", "Infinity", "NaN"};

    public JavaScriptScanner() {
        List<IRule> rules = this.createRules();
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected List<IRule> createRules() {
        Token normal = new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), IHTMLColorConstants.FOREGROUND)));
        Token string = new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), IHTMLColorConstants.JAVA_STRING)));
        Token comment = new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), IHTMLColorConstants.JAVA_COMMENT)));
        Token keyword = new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), IHTMLColorConstants.JAVA_KEYWORD)));
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add((IRule)new SingleLineRule("\\//", null, (IToken)normal));
        rules.add((IRule)new EndOfLineRule("//", (IToken)comment));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), (IToken)normal);
        int i = 0;
        while (i < KEYWORDS.length) {
            wordRule.addWord(KEYWORDS[i], (IToken)keyword);
            ++i;
        }
        rules.add((IRule)wordRule);
        return rules;
    }
}

