/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.AttributeInfo;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.HTMLTemplateAssistProcessor;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.TagDefinition;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.TagInfo;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.TextInfo;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class HTMLCompletionProcessor
extends HTMLTemplateAssistProcessor {
    private int offset;
    private boolean xhtmlMode = false;
    private char[] chars = new char[0];
    private boolean assistCloseTag = true;

    protected String[] getLastWord(String text) {
        StringBuilder sb = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        String word = "";
        String prevTag = "";
        String lastTag = "";
        String attr = "";
        String temp1 = "";
        String temp2 = "";
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '<' && text.length() > i + 1 && text.charAt(i + 1) == '%') {
                if ((i = text.indexOf("%>", i + 2)) == -1) {
                    i = text.length();
                }
            } else if (c == '<' && text.length() > i + 1 && text.charAt(i + 1) == '?') {
                if ((i = text.indexOf("?>", i + 2)) == -1) {
                    i = text.length();
                }
            } else if (this.isDelimiter(c)) {
                temp1 = sb.toString();
                if (temp1.length() > 1 && (temp1.startsWith("\"") && !temp1.endsWith("\"") && c != '\"' || temp1.startsWith("'") && !temp1.endsWith("'") && c != '\'')) {
                    sb.append(c);
                } else if (temp1.length() == 1 && (temp1.equals("\"") || temp1.equals("'"))) {
                    sb.append(c);
                } else {
                    if (!temp1.equals("") && (temp2 = temp1).endsWith("=") && !prevTag.equals("") && !temp2.equals("=")) {
                        attr = temp2.substring(0, temp2.length() - 1);
                    }
                    if (temp1.startsWith("<") && !temp1.startsWith("</") && !temp1.startsWith("<!")) {
                        prevTag = temp1.substring(1);
                        if (!temp1.endsWith("/")) {
                            stack.push(prevTag);
                        }
                    } else if (temp1.startsWith("</") && stack.size() != 0) {
                        stack.pop();
                    } else if (!temp1.startsWith("\"") && !temp1.startsWith("'") && temp1.endsWith("/") && stack.size() != 0) {
                        stack.pop();
                    }
                    sb.setLength(0);
                    if (c == '<') {
                        sb.append(c);
                    } else if (c == '\"' || c == '\'') {
                        if (temp1.startsWith("\"") || temp1.startsWith("'")) {
                            sb.append(temp1);
                        }
                        sb.append(c);
                    } else if (c == '>') {
                        prevTag = "";
                        attr = "";
                    }
                }
            } else {
                if (c == '=' && !prevTag.equals("")) {
                    attr = temp2.trim();
                }
                if ((temp1 = sb.toString()).length() > 1 && temp1.startsWith("\"") && temp1.endsWith("\"") || temp1.startsWith("'") && temp1.endsWith("'")) {
                    sb.setLength(0);
                }
                sb.append(c);
            }
            ++i;
        }
        if (stack.size() != 0) {
            lastTag = (String)stack.pop();
        }
        if (attr.endsWith("=")) {
            attr = attr.substring(0, attr.length() - 1);
        }
        word = sb.toString();
        return new String[]{word, prevTag, lastTag, attr};
    }

    protected boolean isDelimiter(char c) {
        return c == ' ' || c == '(' || c == ')' || c == ',' || c == ';' || c == '\n' || c == '\r' || c == '\t' || c == '+' || c == '>' || c == '<' || c == '*' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '\'';
    }

    protected List<TagInfo> getTagList() {
        return TagDefinition.getTagInfoAsList();
    }

    protected TagInfo getTagInfo(String name) {
        List<TagInfo> tagList = TagDefinition.getTagInfoAsList();
        int i = 0;
        while (i < tagList.size()) {
            TagInfo info = tagList.get(i);
            if (info.getTagName().equals(name)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        TagInfo info;
        int position;
        String assistKeyword;
        String text = viewer.getDocument().get().substring(0, documentOffset);
        String[] dim = this.getLastWord(text);
        String word = dim[0].toLowerCase();
        String prev = dim[1].toLowerCase();
        String last = dim[2];
        this.offset = documentOffset;
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        List<TagInfo> tagList = this.getTagList();
        if (word.startsWith("<") && !word.equals("</")) {
            TagInfo parent = this.getTagInfo(last);
            if (parent != null) {
                String[] childNames = parent.getChildTagNames();
                int i = 0;
                while (i < childNames.length) {
                    tagList.add(this.getTagInfo(childNames[i]));
                    ++i;
                }
            }
            int i = 0;
            while (i < tagList.size()) {
                TagInfo tagInfo = tagList.get(i);
                if (tagInfo instanceof TextInfo) {
                    TextInfo textInfo = (TextInfo)tagInfo;
                    if (textInfo.getText().toLowerCase().indexOf(word) == 0) {
                        list.add((ICompletionProposal)new CompletionProposal(textInfo.getText(), documentOffset - word.length(), word.length(), textInfo.getPosition()));
                    }
                } else {
                    String tagName = tagInfo.getTagName();
                    if (("<" + tagInfo.getTagName().toLowerCase()).indexOf(word) == 0) {
                        assistKeyword = tagName;
                        position = 0;
                        AttributeInfo[] requierAttrs = tagInfo.getRequiredAttributeInfo();
                        int j = 0;
                        while (j < requierAttrs.length) {
                            assistKeyword = String.valueOf(assistKeyword) + " " + requierAttrs[j].getAttributeName();
                            if (requierAttrs[j].hasValue()) {
                                assistKeyword = String.valueOf(assistKeyword) + "=\"\"";
                                if (j == 0) {
                                    position = tagName.length() + requierAttrs[j].getAttributeName().length() + 3;
                                }
                            }
                            ++j;
                        }
                        if (tagInfo.hasBody()) {
                            assistKeyword = String.valueOf(assistKeyword) + ">";
                            if (position == 0) {
                                position = assistKeyword.length();
                            }
                            assistKeyword = String.valueOf(assistKeyword) + "</" + tagName + ">";
                        } else {
                            assistKeyword = tagInfo.isEmptyTag() && !this.xhtmlMode ? String.valueOf(assistKeyword) + ">" : String.valueOf(assistKeyword) + "/>";
                        }
                        if (position == 0) {
                            position = assistKeyword.length();
                        }
                        try {
                            list.add((ICompletionProposal)new CompletionProposal(assistKeyword, documentOffset - word.length() + 1, word.length() - 1, position));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        } else if (!prev.equals("")) {
            String tagName = prev;
            TagInfo tagInfo = this.getTagInfo(tagName);
            if (tagInfo != null) {
                AttributeInfo[] attrList = tagInfo.getAttributeInfo();
                int j = 0;
                while (j < attrList.length) {
                    if (attrList[j].getAttributeName().toLowerCase().indexOf(word) == 0) {
                        assistKeyword = null;
                        position = 0;
                        if (attrList[j].hasValue()) {
                            assistKeyword = String.valueOf(attrList[j].getAttributeName()) + "=\"\"";
                            position = 2;
                        } else {
                            assistKeyword = attrList[j].getAttributeName();
                            position = 0;
                        }
                        list.add((ICompletionProposal)new CompletionProposal(assistKeyword, documentOffset - word.length(), word.length(), attrList[j].getAttributeName().length() + position));
                    }
                    ++j;
                }
            }
        } else if (!last.equals("") && ((info = this.getTagInfo(last)) == null || this.xhtmlMode || info.hasBody() || !info.isEmptyTag())) {
            String contentBefore;
            String assistKeyword2 = "</" + last + ">";
            int length = 0;
            if (word.equals("</")) {
                length = 2;
            }
            if ((contentBefore = viewer.getDocument().get().substring(0, documentOffset - length)).endsWith("\t")) {
                list.add((ICompletionProposal)new CompletionProposal(assistKeyword2, documentOffset - (length + 1), length + 1, assistKeyword2.length()));
            } else {
                list.add((ICompletionProposal)new CompletionProposal(assistKeyword2, documentOffset - length, length, assistKeyword2.length()));
            }
        }
        HTMLCompletionProcessor.sortCompilationProposal(list);
        ICompletionProposal[] templates = super.computeCompletionProposals(viewer, documentOffset);
        int i = 0;
        while (i < templates.length) {
            list.add(templates[i]);
            ++i;
        }
        ICompletionProposal[] prop = list.toArray(new ICompletionProposal[list.size()]);
        return prop;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.chars;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return "Error";
    }

    public static void sortCompilationProposal(List<ICompletionProposal> prop) {
        Collections.sort(prop, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        });
    }

    public void setAutoAssistChars(char[] chars) {
        if (chars != null) {
            this.chars = chars;
        }
    }

    public void setAssistCloseTag(boolean assistCloseTag) {
        this.assistCloseTag = assistCloseTag;
    }
}

