/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers;

import java.util.ResourceBundle;
import org.apache.syncope.ide.eclipse.plugin.editors.TemplateEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class AutoIndentAction
extends TextEditorAction {
    public AutoIndentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.update();
    }

    public void run() {
        String content = this.getCurrentEditorContent();
        content = this.formatContent(content);
        ITextEditor ite = this.getHTMLEditor();
        IDocument doc = ite.getDocumentProvider().getDocument((Object)ite.getEditorInput());
        doc.set(content);
    }

    private String formatContent(String contentarg) {
        String content = contentarg;
        Document htmlDoc = Jsoup.parse((String)content);
        content = htmlDoc.html();
        return content;
    }

    public String getCurrentEditorContent() {
        ITextEditor ite = this.getHTMLEditor();
        IDocument doc = ite.getDocumentProvider().getDocument((Object)ite.getEditorInput());
        return doc.get();
    }

    protected ITextEditor getHTMLEditor() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editor instanceof TemplateEditor)) {
            return null;
        }
        TemplateEditor te = (TemplateEditor)editor;
        return te.getActiveHTMLEditor();
    }

    public void update() {
        this.setEnabled(true);
    }
}

