/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors;

import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.HTMLAutoEditStrategy;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.HTMLCompletionProcessor;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.HTMLScanner;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.HTMLTagDamagerRepairer;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.HTMLTagScanner;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.IHTMLColorConstants;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.InnerCSSScanner;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.InnerJavaScriptScanner;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.JavaScriptDamagerRepairer;
import org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers.SyncopeTagScanner;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class HTMLSourceConfiguration
extends TextSourceViewerConfiguration {
    private HTMLTagScanner tagScanner;
    private SyncopeTagScanner syncopeTagScanner;
    private HTMLScanner scanner;
    private RuleBasedScanner commentScanner;
    private RuleBasedScanner scriptScanner;
    private RuleBasedScanner doctypeScanner;
    private RuleBasedScanner directiveScanner;
    private RuleBasedScanner javaScriptScanner;
    private RuleBasedScanner cssScanner;
    private ContentAssistant contentAssistant = new ContentAssistant();
    private HTMLAutoEditStrategy autoEditStrategy;

    public HTMLSourceConfiguration() {
        HTMLCompletionProcessor proc = new HTMLCompletionProcessor();
        proc.setAutoAssistChars("</\"".toCharArray());
        proc.setAssistCloseTag(true);
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)proc, "__dftl_partition_content_type");
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)proc, "__dftl_partition_content_type");
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)proc, "__html_tag");
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)proc, "__prefix_tag");
        this.contentAssistant.enableAutoActivation(true);
        this.contentAssistant.setContextInformationPopupOrientation(20);
    }

    protected HTMLAutoEditStrategy createAutoEditStrategy() {
        return new HTMLAutoEditStrategy();
    }

    public final HTMLAutoEditStrategy getAutoEditStrategy() {
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createAutoEditStrategy();
        }
        return this.autoEditStrategy;
    }

    public final IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getAutoEditStrategy()};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return this.contentAssistant;
    }

    protected HTMLTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new HTMLTagScanner(false);
            RGB rgb = IHTMLColorConstants.TAG;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.tagScanner;
    }

    protected SyncopeTagScanner getSyncopeTagScanner() {
        if (this.syncopeTagScanner == null) {
            this.syncopeTagScanner = new SyncopeTagScanner(false);
            RGB rgb = IHTMLColorConstants.HTML_COMMENT;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.syncopeTagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.syncopeTagScanner;
    }

    protected HTMLScanner getHTMLScanner() {
        if (this.scanner == null) {
            this.scanner = new HTMLScanner();
            RGB rgb = IHTMLColorConstants.FOREGROUND;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.scanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new RuleBasedScanner();
            RGB rgb = IHTMLColorConstants.HTML_COMMENT;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.commentScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.commentScanner;
    }

    protected RuleBasedScanner getScriptScanner() {
        if (this.scriptScanner == null) {
            this.scriptScanner = new RuleBasedScanner();
            RGB rgb = IHTMLColorConstants.SCRIPT;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.scriptScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.scriptScanner;
    }

    protected RuleBasedScanner getDoctypeScanner() {
        if (this.doctypeScanner == null) {
            this.doctypeScanner = new RuleBasedScanner();
            RGB rgb = IHTMLColorConstants.PROC_INSTR;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.doctypeScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.doctypeScanner;
    }

    protected RuleBasedScanner getDirectiveScanner() {
        if (this.directiveScanner == null) {
            this.directiveScanner = new RuleBasedScanner();
            RGB rgb = IHTMLColorConstants.SCRIPT;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.directiveScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.directiveScanner;
    }

    protected RuleBasedScanner getJavaScriptScanner() {
        if (this.javaScriptScanner == null) {
            this.javaScriptScanner = new InnerJavaScriptScanner();
            RGB rgb = IHTMLColorConstants.FOREGROUND;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.javaScriptScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.javaScriptScanner;
    }

    protected RuleBasedScanner getCSSScanner() {
        if (this.cssScanner == null) {
            this.cssScanner = new InnerCSSScanner();
            RGB rgb = IHTMLColorConstants.FOREGROUND;
            Color color = new Color((Device)Display.getCurrent(), rgb);
            this.cssScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(color)));
        }
        return this.cssScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = null;
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_tag");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__prefix_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__prefix_tag");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getSyncopeTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__syncope_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__syncope_tag");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getHTMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_script");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_script");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDoctypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_doctype");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_directive");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_directive");
        dr = new JavaScriptDamagerRepairer((ITokenScanner)this.getJavaScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_javascript");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_javascript");
        dr = new JavaScriptDamagerRepairer((ITokenScanner)this.getCSSScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_css");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_css");
        return reconciler;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_comment", "__html_tag", "__prefix_tag", "__html_script", "__html_doctype", "__html_directive", "__html_javascript", "__html_css", "__syncope_tag"};
    }
}

