/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import java.util.Date;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlEnum;
import org.apache.commons.lang3.ClassUtils;

@XmlEnum
public enum AttrSchemaType {
    String(String.class),
    Long(Long.class),
    Double(Double.class),
    Boolean(Boolean.class),
    Date(Date.class),
    Enum(Enum.class),
    Binary(byte[].class),
    Encrypted(byte[].class);

    private final Class<?> type;

    private AttrSchemaType(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isConversionPatternNeeded() {
        return this == Date || this == Double || this == Long;
    }

    public static AttrSchemaType getAttrSchemaTypeByClass(Class<?> type) {
        return Stream.of(AttrSchemaType.values()).filter(item -> type.isArray() ? ClassUtils.isAssignable(type.getComponentType(), item.getType().getComponentType(), (boolean)true) : ClassUtils.isAssignable((Class)type, item.getType(), (boolean)true)).findFirst().orElse(String);
    }
}

