/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.jaxb.XmlGenericMapAdapter;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;

@XmlRootElement(name="schema")
@XmlType
@XmlSeeAlso(value={PlainSchemaTO.class, DerSchemaTO.class, VirSchemaTO.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@class")
@JsonPropertyOrder(value={"@class", "key"})
@Schema(subTypes={PlainSchemaTO.class, DerSchemaTO.class, VirSchemaTO.class}, discriminatorProperty="@class")
public abstract class SchemaTO
implements EntityTO {
    private static final long serialVersionUID = 4088388951694301759L;
    @XmlTransient
    @JsonProperty(value="@class")
    private String discriminator;
    private String key;
    private String anyTypeClass;
    @XmlJavaTypeAdapter(value=XmlGenericMapAdapter.class)
    private final Map<String, String> labels = new HashMap<String, String>();

    public static Locale toLocale(String string) {
        String[] splitted = string.split(";");
        String language = "";
        String country = "";
        String variant = "";
        if (splitted.length > 0) {
            language = splitted[0];
        }
        if (splitted.length > 1) {
            country = splitted[1];
        }
        if (splitted.length > 2) {
            variant = splitted[2];
        }
        return new Locale(language, country, variant);
    }

    public static String toString(Locale locale) {
        return locale.getLanguage() + ";" + locale.getCountry() + ";" + locale.getVariant();
    }

    @Schema(name="@class", required=true)
    public abstract String getDiscriminator();

    public void setDiscriminator(String discriminator) {
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public String getAnyTypeClass() {
        return this.anyTypeClass;
    }

    public void setAnyTypeClass(String anyTypeClass) {
        this.anyTypeClass = anyTypeClass;
    }

    @JsonIgnore
    public String getLabel(Locale locale) {
        return this.labels.getOrDefault(SchemaTO.toString(locale), this.key);
    }

    @JsonProperty
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.discriminator).append((Object)this.key).append((Object)this.anyTypeClass).append(this.labels).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTO other = (SchemaTO)obj;
        return new EqualsBuilder().append((Object)this.discriminator, (Object)other.discriminator).append((Object)this.key, (Object)other.key).append((Object)this.anyTypeClass, (Object)other.anyTypeClass).append(this.labels, other.labels).build();
    }
}

