/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

public final class EntityTOUtils {
    public static Map<String, AttrTO> buildAttrMap(Collection<AttrTO> attrs) {
        return Collections.unmodifiableMap(attrs.stream().collect(Collectors.toMap(AttrTO::getSchema, Function.identity(), (exist, repl) -> repl)));
    }

    public static Map<Pair<String, String>, RelationshipTO> buildRelationshipMap(Collection<RelationshipTO> relationships) {
        return Collections.unmodifiableMap(relationships.stream().collect(Collectors.toMap(rel -> Pair.of((Object)rel.getType(), (Object)rel.getOtherEndKey()), Function.identity(), (exist, repl) -> repl)));
    }

    public static Map<String, MembershipTO> buildMembershipMap(Collection<MembershipTO> memberships) {
        return Collections.unmodifiableMap(memberships.stream().collect(Collectors.toMap(MembershipTO::getGroupKey, Function.identity(), (exist, repl) -> repl)));
    }

    public static Map<Pair<String, String>, LinkedAccountTO> buildLinkedAccountMap(Collection<LinkedAccountTO> accounts) {
        return Collections.unmodifiableMap(accounts.stream().collect(Collectors.toMap(account -> Pair.of((Object)account.getResource(), (Object)account.getConnObjectKeyValue()), Function.identity(), (exist, repl) -> repl)));
    }

    private EntityTOUtils() {
    }
}

