/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.view;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class Table {
    private static final String TABLE_TITLE_FORMAT = "#  %s  #%n";
    private final String title;
    private final List<String> headers;
    private final Set<List<String>> values;
    private int columnsNumber;
    private Object[] tmpValuesArray;
    private String tableContentFormat;
    private int[] columnsSize;
    private int tableWidth;
    private String border = "";

    private Table(String title, List<String> headers, Set<List<String>> values) {
        this.title = title;
        this.headers = headers;
        this.values = values;
    }

    public void print() {
        System.out.println("");
        this.columnsNumber = this.headers.size();
        this.tmpValuesArray = new String[this.columnsNumber];
        this.buildTableContentFormat();
        this.initializeColumnSize();
        this.countTableWidth();
        this.printBorder();
        this.printTitle();
        this.printBorder();
        this.printHeaders();
        this.printBorder();
        this.printeContent();
        this.printBorder();
        System.out.println("");
    }

    private void buildTableContentFormat() {
        StringBuilder tableContentFormatBuilder = new StringBuilder("#");
        for (int s = 0; s < this.columnsNumber; ++s) {
            tableContentFormatBuilder.append("  %s  #");
        }
        tableContentFormatBuilder.append("\n");
        this.tableContentFormat = tableContentFormatBuilder.toString();
    }

    private void initializeColumnSize() {
        this.columnsSize = new int[this.columnsNumber];
        for (int j = 0; j < this.columnsSize.length; ++j) {
            this.columnsSize[j] = 0;
        }
        for (int i = 0; i < this.columnsSize.length; ++i) {
            if (this.headers.get(i).length() <= this.columnsSize[i]) continue;
            this.columnsSize[i] = this.headers.get(i).length();
        }
        this.values.forEach(value -> {
            for (int j = 0; j < this.columnsSize.length; ++j) {
                if (value.get(j) == null || ((String)value.get(j)).length() <= this.columnsSize[j]) continue;
                this.columnsSize[j] = ((String)value.get(j)).length();
            }
        });
    }

    private void countTableWidth() {
        int maxColumnValueSum = 0;
        for (int j = 0; j < this.columnsSize.length; ++j) {
            maxColumnValueSum += this.columnsSize[j];
        }
        this.tableWidth = maxColumnValueSum + this.columnsNumber * 4 + this.columnsNumber + 1;
    }

    private void printBorder() {
        if (this.border.isEmpty()) {
            StringBuilder borderBuilder = new StringBuilder();
            for (int j = 0; j < this.tableWidth; ++j) {
                borderBuilder.append("#");
            }
            this.border = borderBuilder.toString();
        }
        System.out.println(this.border);
    }

    private void printTitle() {
        System.out.format(TABLE_TITLE_FORMAT, StringUtils.center((String)" ", (int)(this.tableWidth - 6)));
        System.out.format(TABLE_TITLE_FORMAT, StringUtils.center((String)this.title.toUpperCase(), (int)(this.tableWidth - 6)));
        System.out.format(TABLE_TITLE_FORMAT, StringUtils.center((String)" ", (int)(this.tableWidth - 6)));
    }

    private void printHeaders() {
        this.printColumnSpace();
        for (int h = 0; h < this.columnsNumber; ++h) {
            this.tmpValuesArray[h] = StringUtils.center((String)this.headers.get(h).toUpperCase(), (int)this.columnsSize[h]);
        }
        System.out.format(this.tableContentFormat, this.tmpValuesArray);
        this.printColumnSpace();
    }

    private void printeContent() {
        this.printColumnSpace();
        this.values.forEach(value -> {
            for (int j = 0; j < this.columnsNumber; ++j) {
                this.tmpValuesArray[j] = value.get(j) == null ? StringUtils.center((String)"null", (int)this.columnsSize[j]) : StringUtils.center((String)((String)value.get(j)), (int)this.columnsSize[j]);
            }
            System.out.format(this.tableContentFormat, this.tmpValuesArray);
        });
        this.printColumnSpace();
    }

    private void printColumnSpace() {
        for (int h = 0; h < this.columnsNumber; ++h) {
            this.tmpValuesArray[h] = StringUtils.center((String)" ", (int)this.columnsSize[h]);
        }
        System.out.format(this.tableContentFormat, this.tmpValuesArray);
    }

    public static class TableBuilder {
        private final List<String> headers = new ArrayList<String>();
        private final Set<List<String>> values = new LinkedHashSet<List<String>>();
        private final String title;

        public TableBuilder(String title) {
            this.title = title;
        }

        public TableBuilder header(String header) {
            this.headers.add(header);
            return this;
        }

        public TableBuilder rowValues(List<String> row) {
            this.values.add(row);
            return this;
        }

        public Table build() {
            return new Table(this.title, this.headers, this.values);
        }
    }
}

