/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.CommandClassScanner;
import org.apache.syncope.client.cli.commands.AbstractCommand;

public final class CommandUtils {
    public static AbstractCommand fromArgs(String arg) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CommandClassScanner ccs = new CommandClassScanner();
        List<Class<? extends AbstractCommand>> commands = ccs.getComponentClasses();
        Class<? extends AbstractCommand> commandClass = null;
        for (Class<? extends AbstractCommand> cmd : commands) {
            if (!arg.equals(cmd.getAnnotation(Command.class).name())) continue;
            commandClass = cmd;
        }
        if (commandClass == null) {
            throw new IllegalArgumentException(arg + " is not a valid command");
        }
        return (AbstractCommand)commandClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static List<AbstractCommand> commands() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        ArrayList<AbstractCommand> listCommands = new ArrayList<AbstractCommand>();
        CommandClassScanner ccs = new CommandClassScanner();
        List<Class<? extends AbstractCommand>> commands = ccs.getComponentClasses();
        for (Class<? extends AbstractCommand> cmd : commands) {
            if (cmd == null) {
                throw new IllegalArgumentException();
            }
            listCommands.add(cmd.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        return listCommands;
    }

    public static String[] fromEnumToArray(Class<? extends Enum<?>> enumClass) {
        String[] types = new String[enumClass.getFields().length];
        for (int i = 0; i < enumClass.getFields().length; ++i) {
            types[i] = enumClass.getFields()[i].getName();
        }
        return types;
    }

    public static String helpMessage(String command, List<String> options) {
        StringBuilder helpMessageBuilder = new StringBuilder(String.format("%nUsage: %s [options]%n", command));
        helpMessageBuilder.append("  Options:\n");
        options.forEach(option -> helpMessageBuilder.append("    ").append((String)option).append("\n"));
        return helpMessageBuilder.toString();
    }

    private CommandUtils() {
    }
}

