/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSearchByAttribute
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserSearchByAttribute.class);
    private static final String SEARCH_HELP_MESSAGE = "user --search-by-attribute {REALM} {ATTR-NAME}={ATTR-VALUE}";
    private final Input input;

    public UserSearchByAttribute(Input input) {
        this.input = input;
    }

    public void search() {
        block8: {
            if (this.input.parameterNumber() == 2) {
                String realm = this.input.firstParameter();
                Pair<String, String> pairParameter = Input.toPairParameter(this.input.secondParameter());
                try {
                    List<UserTO> userTOs;
                    if (!this.realmSyncopeOperations.exists(realm)) {
                        this.userResultManager.genericMessage("Operation performed on root realm because " + realm + " does not exists");
                    }
                    if ((userTOs = this.userSyncopeOperations.searchByAttribute(realm, (String)pairParameter.getKey(), (String)pairParameter.getValue())).isEmpty()) {
                        this.userResultManager.genericMessage("No users found with attribute " + (String)pairParameter.getKey() + " and value " + (String)pairParameter.getValue());
                        break block8;
                    }
                    this.userResultManager.printUsers(userTOs);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error searching user", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.userResultManager.notFoundError("User with " + (String)pairParameter.getKey(), (String)pairParameter.getValue());
                        break block8;
                    }
                    this.userResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error searching user", (Throwable)ex);
                    this.userResultManager.genericError(ex.getMessage());
                    this.userResultManager.genericError(SEARCH_HELP_MESSAGE);
                }
            } else {
                this.userResultManager.commandOptionError(SEARCH_HELP_MESSAGE);
            }
        }
    }
}

