/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserReadByUsername
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserReadByUsername.class);
    private static final String READ_HELP_MESSAGE = "user --read-by-username {USERNAME} {USERNAME} [...]";
    private final Input input;

    public UserReadByUsername(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.getParameters().length >= 1) {
            ArrayList<UserTO> userTOs = new ArrayList<UserTO>();
            for (String parameter : this.input.getParameters()) {
                try {
                    userTOs.add(this.userSyncopeOperations.read(parameter));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading user", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.userResultManager.notFoundError("User", parameter);
                        break;
                    }
                    this.userResultManager.genericError(ex.getMessage());
                    break;
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading user", (Throwable)ex);
                    this.userResultManager.numberFormatException("user", parameter);
                }
            }
            this.userResultManager.printUsers(userTOs);
        } else {
            this.userResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

