/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.Scanner;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserList
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserList.class);
    private static final String LIST_HELP_MESSAGE = "user --list";
    private final Input input;

    public UserList(Input input) {
        this.input = input;
    }

    public void list() {
        block6: {
            if (this.input.parameterNumber() == 0) {
                try {
                    Scanner scanIn = new Scanner(System.in);
                    System.out.println("\nThis operation might produce very large output. Do you want to continue? [yes/no]");
                    String answer = scanIn.nextLine();
                    if ("yes".equalsIgnoreCase(answer)) {
                        this.userResultManager.printUsers(this.userSyncopeOperations.list());
                        break block6;
                    }
                    if ("no".equalsIgnoreCase(answer)) {
                        this.userResultManager.genericError("List operation skipped");
                        break block6;
                    }
                    this.userResultManager.genericError("Invalid parameter, please use [yes/no]");
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error listing user", (Throwable)ex);
                    this.userResultManager.genericError(ex.getMessage());
                }
            } else {
                this.userResultManager.unnecessaryParameters(this.input.listParameters(), LIST_HELP_MESSAGE);
            }
        }
    }
}

