/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.user.UserDelete;
import org.apache.syncope.client.cli.commands.user.UserDeleteAll;
import org.apache.syncope.client.cli.commands.user.UserDeleteByAttribute;
import org.apache.syncope.client.cli.commands.user.UserDetails;
import org.apache.syncope.client.cli.commands.user.UserList;
import org.apache.syncope.client.cli.commands.user.UserReadByUserKey;
import org.apache.syncope.client.cli.commands.user.UserReadByUsername;
import org.apache.syncope.client.cli.commands.user.UserResultManager;
import org.apache.syncope.client.cli.commands.user.UserSearchByAttribute;
import org.apache.syncope.client.cli.commands.user.UserSearchByResource;
import org.apache.syncope.client.cli.commands.user.UserSearchByRole;

@Command(name="user")
public class UserCommand
extends AbstractCommand {
    private final UserResultManager userResultManager = new UserResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(UserOptions.HELP.getOptionName());
        }
        switch (UserOptions.fromName(input.getOption())) {
            case DETAILS: {
                new UserDetails(input).details();
                break;
            }
            case LIST: {
                new UserList(input).list();
                break;
            }
            case READ_BY_KEY: {
                new UserReadByUserKey(input).read();
                break;
            }
            case READ_BY_USERNAME: {
                new UserReadByUsername(input).read();
                break;
            }
            case SEARCH_BY_ATTRIBUTE: {
                new UserSearchByAttribute(input).search();
                break;
            }
            case SEARCH_BY_ROLE: {
                new UserSearchByRole(input).search();
                break;
            }
            case SEARCH_BY_RESOURCE: {
                new UserSearchByResource(input).search();
                break;
            }
            case DELETE: {
                new UserDelete(input).delete();
                break;
            }
            case DELETE_ALL: {
                new UserDeleteAll(input).delete();
                break;
            }
            case DELETE_BY_ATTRIBUTE: {
                new UserDeleteByAttribute(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.userResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.userResultManager.commandHelpMessage(this.getClass());
    }

    public static enum UserOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        READ_BY_KEY("--read-by-userkey"),
        READ_BY_USERNAME("--read-by-username"),
        SEARCH_BY_ATTRIBUTE("--search-by-attribute"),
        SEARCH_BY_ROLE("--search-by-role"),
        SEARCH_BY_RESOURCE("--search-by-resource"),
        DELETE("--delete"),
        DELETE_ALL("--delete-all"),
        DELETE_BY_ATTRIBUTE("--delete-by-attribute");

        private final String optionName;

        private UserOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static UserOptions fromName(String name) {
            UserOptions optionToReturn = HELP;
            for (UserOptions option : UserOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (UserOptions value : UserOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

