/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRead
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRead.class);
    private static final String READ_HELP_MESSAGE = "task --read {TASK-TYPE} {TASK-KEY}\n   Task type:  PROPAGATION / NOTIFICATION / SCHEDULED / PULL / PUSH";
    private final Input input;

    public TaskRead(Input input) {
        this.input = input;
    }

    public void read() {
        block7: {
            if (this.input.parameterNumber() >= 2) {
                String[] parameters = Arrays.copyOfRange(this.input.getParameters(), 1, this.input.parameterNumber());
                try {
                    ArrayList<TaskTO> taskTOs = new ArrayList<TaskTO>();
                    for (String parameter : parameters) {
                        taskTOs.add((TaskTO)this.taskSyncopeOperations.read(this.input.firstParameter(), parameter));
                    }
                    this.taskResultManager.printTasks(taskTOs);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading task", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.taskResultManager.notFoundError("Task", parameters[0]);
                        break block7;
                    }
                    this.taskResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error reading task", (Throwable)ex);
                    this.taskResultManager.typeNotValidError("task", this.input.firstParameter(), CommandUtils.fromEnumToArray(TaskType.class));
                }
            } else {
                this.taskResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

