/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.task;

import java.util.List;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.task.AbstractTaskCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.JobTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskListJobs
extends AbstractTaskCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TaskListJobs.class);
    private static final String READ_HELP_MESSAGE = "task --list-jobs";
    private final Input input;

    public TaskListJobs(Input input) {
        this.input = input;
    }

    public void list() {
        block5: {
            if (this.input.parameterNumber() == 0) {
                try {
                    List<JobTO> jobs = this.taskSyncopeOperations.listJobs();
                    if (jobs.isEmpty()) {
                        this.taskResultManager.genericMessage("There are NO jobs available");
                        break block5;
                    }
                    this.taskResultManager.printJobs(jobs);
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error listing jobs", (Throwable)ex);
                    this.taskResultManager.genericError(ex.getMessage());
                }
            } else {
                this.taskResultManager.unnecessaryParameters(this.input.listParameters(), READ_HELP_MESSAGE);
            }
        }
    }
}

